/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.NotificationResource;
import software.amazon.awssdk.services.datazone.model.NotificationRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Topic
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Topic> {
    private static final SdkField<NotificationResource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(Topic.getter(Topic::resource)).setter(Topic.setter(Builder::resource)).constructor(NotificationResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(Topic.getter(Topic::roleAsString)).setter(Topic.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(Topic.getter(Topic::subject)).setter(Topic.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, ROLE_FIELD, SUBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final NotificationResource resource;
    private final String role;
    private final String subject;

    private Topic(BuilderImpl builder) {
        this.resource = builder.resource;
        this.role = builder.role;
        this.subject = builder.subject;
    }

    public final NotificationResource resource() {
        return this.resource;
    }

    public final NotificationRole role() {
        return NotificationRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final String subject() {
        return this.subject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.subject(), other.subject());
    }

    public final String toString() {
        return ToString.builder((String)"Topic").add("Resource", (Object)this.resource()).add("Role", (Object)this.roleAsString()).add("Subject", (Object)this.subject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Topic, T> g) {
        return obj -> g.apply((Topic)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NotificationResource resource;
        private String role;
        private String subject;

        private BuilderImpl() {
        }

        private BuilderImpl(Topic model) {
            this.resource(model.resource);
            this.role(model.role);
            this.subject(model.subject);
        }

        public final NotificationResource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(NotificationResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(NotificationResource resource) {
            this.resource = resource;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NotificationRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Topic build() {
            return new Topic(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Topic> {
        public Builder resource(NotificationResource var1);

        default public Builder resource(Consumer<NotificationResource.Builder> resource) {
            return this.resource((NotificationResource)((NotificationResource.Builder)NotificationResource.builder().applyMutation(resource)).build());
        }

        public Builder role(String var1);

        public Builder role(NotificationRole var1);

        public Builder subject(String var1);
    }
}

