/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.GlossaryTermStatus;
import software.amazon.awssdk.services.datazone.model.TermRelations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGlossaryTermResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetGlossaryTermResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::createdAt)).setter(GetGlossaryTermResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::createdBy)).setter(GetGlossaryTermResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::domainId)).setter(GetGlossaryTermResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> GLOSSARY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glossaryId").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::glossaryId)).setter(GetGlossaryTermResponse.setter(Builder::glossaryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::id)).setter(GetGlossaryTermResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("longDescription").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::longDescription)).setter(GetGlossaryTermResponse.setter(Builder::longDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::name)).setter(GetGlossaryTermResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortDescription").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::shortDescription)).setter(GetGlossaryTermResponse.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::statusAsString)).setter(GetGlossaryTermResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("termRelations").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::termRelations)).setter(GetGlossaryTermResponse.setter(Builder::termRelations)).constructor(TermRelations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::updatedAt)).setter(GetGlossaryTermResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetGlossaryTermResponse.getter(GetGlossaryTermResponse::updatedBy)).setter(GetGlossaryTermResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, GLOSSARY_ID_FIELD, ID_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD, STATUS_FIELD, TERM_RELATIONS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final String glossaryId;
    private final String id;
    private final String longDescription;
    private final String name;
    private final String shortDescription;
    private final String status;
    private final TermRelations termRelations;
    private final Instant updatedAt;
    private final String updatedBy;

    private GetGlossaryTermResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.glossaryId = builder.glossaryId;
        this.id = builder.id;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String glossaryId() {
        return this.glossaryId;
    }

    public final String id() {
        return this.id;
    }

    public final String longDescription() {
        return this.longDescription;
    }

    public final String name() {
        return this.name;
    }

    public final String shortDescription() {
        return this.shortDescription;
    }

    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TermRelations termRelations() {
        return this.termRelations;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.glossaryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termRelations());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlossaryTermResponse)) {
            return false;
        }
        GetGlossaryTermResponse other = (GetGlossaryTermResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.glossaryId(), other.glossaryId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.longDescription(), other.longDescription()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.termRelations(), other.termRelations()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetGlossaryTermResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("GlossaryId", (Object)this.glossaryId()).add("Id", (Object)this.id()).add("LongDescription", (Object)(this.longDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ShortDescription", (Object)(this.shortDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("TermRelations", (Object)this.termRelations()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "glossaryId": {
                return Optional.ofNullable(clazz.cast(this.glossaryId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "longDescription": {
                return Optional.ofNullable(clazz.cast(this.longDescription()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "shortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "termRelations": {
                return Optional.ofNullable(clazz.cast(this.termRelations()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGlossaryTermResponse, T> g) {
        return obj -> g.apply((GetGlossaryTermResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private String glossaryId;
        private String id;
        private String longDescription;
        private String name;
        private String shortDescription;
        private String status;
        private TermRelations termRelations;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlossaryTermResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.glossaryId(model.glossaryId);
            this.id(model.id);
            this.longDescription(model.longDescription);
            this.name(model.name);
            this.shortDescription(model.shortDescription);
            this.status(model.status);
            this.termRelations(model.termRelations);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGlossaryId() {
            return this.glossaryId;
        }

        public final void setGlossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
        }

        @Override
        public final Builder glossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLongDescription() {
            return this.longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return this.termRelations != null ? this.termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetGlossaryTermResponse build() {
            return new GetGlossaryTermResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGlossaryTermResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder glossaryId(String var1);

        public Builder id(String var1);

        public Builder longDescription(String var1);

        public Builder name(String var1);

        public Builder shortDescription(String var1);

        public Builder status(String var1);

        public Builder status(GlossaryTermStatus var1);

        public Builder termRelations(TermRelations var1);

        default public Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return this.termRelations((TermRelations)((TermRelations.Builder)TermRelations.builder().applyMutation(termRelations)).build());
        }

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

