/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;

public class ListTaskExecutionsIterable
implements SdkIterable<ListTaskExecutionsResponse> {
    private final DataSyncClient client;
    private final ListTaskExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskExecutionsIterable(DataSyncClient client, ListTaskExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTaskExecutionsResponseFetcher();
    }

    public Iterator<ListTaskExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTaskExecutionsResponseFetcher
    implements SyncPageFetcher<ListTaskExecutionsResponse> {
        private ListTaskExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskExecutionsResponse nextPage(ListTaskExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaskExecutionsIterable.this.client.listTaskExecutions(ListTaskExecutionsIterable.this.firstRequest);
            }
            return ListTaskExecutionsIterable.this.client.listTaskExecutions((ListTaskExecutionsRequest)((Object)ListTaskExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

