/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.AgentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentListEntry> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentListEntry.getter(AgentListEntry::agentArn)).setter(AgentListEntry.setter(Builder::agentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentListEntry.getter(AgentListEntry::name)).setter(AgentListEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentListEntry.getter(AgentListEntry::statusAsString)).setter(AgentListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentArn;
    private final String name;
    private final String status;

    private AgentListEntry(BuilderImpl builder) {
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
    }

    public String agentArn() {
        return this.agentArn;
    }

    public String name() {
        return this.name;
    }

    public AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentListEntry)) {
            return false;
        }
        AgentListEntry other = (AgentListEntry)obj;
        return Objects.equals(this.agentArn(), other.agentArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"AgentListEntry").add("AgentArn", (Object)this.agentArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentArn": {
                return Optional.ofNullable(clazz.cast(this.agentArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentListEntry, T> g) {
        return obj -> g.apply((AgentListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentArn;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentListEntry model) {
            this.agentArn(model.agentArn);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getAgentArn() {
            return this.agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public AgentListEntry build() {
            return new AgentListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentListEntry> {
        public Builder agentArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);
    }
}

