/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.CreateAgentRequest;
import software.amazon.awssdk.services.datasync.model.CreateAgentResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Request;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Response;
import software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.CreateTaskRequest;
import software.amazon.awssdk.services.datasync.model.CreateTaskResponse;
import software.amazon.awssdk.services.datasync.model.DataSyncException;
import software.amazon.awssdk.services.datasync.model.DeleteAgentRequest;
import software.amazon.awssdk.services.datasync.model.DeleteAgentResponse;
import software.amazon.awssdk.services.datasync.model.DeleteLocationRequest;
import software.amazon.awssdk.services.datasync.model.DeleteLocationResponse;
import software.amazon.awssdk.services.datasync.model.DeleteTaskRequest;
import software.amazon.awssdk.services.datasync.model.DeleteTaskResponse;
import software.amazon.awssdk.services.datasync.model.DescribeAgentRequest;
import software.amazon.awssdk.services.datasync.model.DescribeAgentResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response;
import software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskResponse;
import software.amazon.awssdk.services.datasync.model.InternalException;
import software.amazon.awssdk.services.datasync.model.InvalidRequestException;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;
import software.amazon.awssdk.services.datasync.model.ListLocationsRequest;
import software.amazon.awssdk.services.datasync.model.ListLocationsResponse;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;
import software.amazon.awssdk.services.datasync.model.ListTasksRequest;
import software.amazon.awssdk.services.datasync.model.ListTasksResponse;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.TagResourceRequest;
import software.amazon.awssdk.services.datasync.model.TagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UntagResourceRequest;
import software.amazon.awssdk.services.datasync.model.UntagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UpdateAgentRequest;
import software.amazon.awssdk.services.datasync.model.UpdateAgentResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request;
import software.amazon.awssdk.services.datasync.model.UpdateLocationS3Response;
import software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.UpdateTaskRequest;
import software.amazon.awssdk.services.datasync.model.UpdateTaskResponse;
import software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTasksIterable;

/**
 * Service client for accessing DataSync. This can be created using the static {@link #builder()} method.
 *
 * <fullname>DataSync</fullname>
 * <p>
 * DataSync is an online data movement service that simplifies data migration and helps you quickly, easily, and
 * securely transfer your file or object data to, from, and between Amazon Web Services storage services.
 * </p>
 * <p>
 * This API interface reference includes documentation for using DataSync programmatically. For complete information,
 * see the <i> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/what-is-datasync.html">DataSync User
 * Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataSyncClient extends AwsClient {
    String SERVICE_NAME = "datasync";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datasync";

    /**
     * <p>
     * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File
     * contents that're transferred to the destination might be incomplete or inconsistent with the source files.
     * </p>
     * <p>
     * However, if you start a new task execution using the same task and allow it to finish, file content on the
     * destination will be complete and consistent. This applies to other unexpected failures that interrupt a task
     * execution. In all of these cases, DataSync successfully completes the transfer when you start the next task
     * execution.
     * </p>
     *
     * @param cancelTaskExecutionRequest
     *        CancelTaskExecutionRequest
     * @return Result of the CancelTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CancelTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelTaskExecutionResponse cancelTaskExecution(CancelTaskExecutionRequest cancelTaskExecutionRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File
     * contents that're transferred to the destination might be incomplete or inconsistent with the source files.
     * </p>
     * <p>
     * However, if you start a new task execution using the same task and allow it to finish, file content on the
     * destination will be complete and consistent. This applies to other unexpected failures that interrupt a task
     * execution. In all of these cases, DataSync successfully completes the transfer when you start the next task
     * execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelTaskExecutionRequest#builder()}
     * </p>
     *
     * @param cancelTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest.Builder} to create a
     *        request. CancelTaskExecutionRequest
     * @return Result of the CancelTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CancelTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelTaskExecutionResponse cancelTaskExecution(
            Consumer<CancelTaskExecutionRequest.Builder> cancelTaskExecutionRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return cancelTaskExecution(CancelTaskExecutionRequest.builder().applyMutation(cancelTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Activates an DataSync agent that you deploy in your storage environment. The activation process associates the
     * agent with your Amazon Web Services account.
     * </p>
     * <p>
     * If you haven't deployed an agent yet, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html">Do I need a DataSync
     * agent?</a>
     * </p>
     *
     * @param createAgentRequest
     *        CreateAgentRequest
     * @return Result of the CreateAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentResponse createAgent(CreateAgentRequest createAgentRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an DataSync agent that you deploy in your storage environment. The activation process associates the
     * agent with your Amazon Web Services account.
     * </p>
     * <p>
     * If you haven't deployed an agent yet, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html">Do I need a DataSync
     * agent?</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAgentRequest#builder()}
     * </p>
     *
     * @param createAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateAgentRequest.Builder} to create a request.
     *        CreateAgentRequest
     * @return Result of the CreateAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentResponse createAgent(Consumer<CreateAgentRequest.Builder> createAgentRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createAgent(CreateAgentRequest.builder().applyMutation(createAgentRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Microsoft Azure Blob Storage container. DataSync can use this location
     * as a transfer source or destination. You can make transfers with or without a <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent"
     * >DataSync agent</a> that connects to your container.
     * </p>
     * <p>
     * Before you begin, make sure you know <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access">how
     * DataSync accesses Azure Blob Storage</a> and works with <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >access tiers</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types">blob
     * types</a>.
     * </p>
     *
     * @param createLocationAzureBlobRequest
     * @return Result of the CreateLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationAzureBlobResponse createLocationAzureBlob(CreateLocationAzureBlobRequest createLocationAzureBlobRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Microsoft Azure Blob Storage container. DataSync can use this location
     * as a transfer source or destination. You can make transfers with or without a <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent"
     * >DataSync agent</a> that connects to your container.
     * </p>
     * <p>
     * Before you begin, make sure you know <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access">how
     * DataSync accesses Azure Blob Storage</a> and works with <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >access tiers</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types">blob
     * types</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param createLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationAzureBlobResponse createLocationAzureBlob(
            Consumer<CreateLocationAzureBlobRequest.Builder> createLocationAzureBlobRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationAzureBlob(CreateLocationAzureBlobRequest.builder().applyMutation(createLocationAzureBlobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon EFS file system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access"
     * >accesses Amazon EFS file systems</a>.
     * </p>
     *
     * @param createLocationEfsRequest
     *        CreateLocationEfsRequest
     * @return Result of the CreateLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationEfsResponse createLocationEfs(CreateLocationEfsRequest createLocationEfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon EFS file system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access"
     * >accesses Amazon EFS file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationEfsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationEfsRequest#builder()}
     * </p>
     *
     * @param createLocationEfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest.Builder} to create a
     *        request. CreateLocationEfsRequest
     * @return Result of the CreateLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationEfsResponse createLocationEfs(Consumer<CreateLocationEfsRequest.Builder> createLocationEfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationEfs(CreateLocationEfsRequest.builder().applyMutation(createLocationEfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Lustre file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access"
     * >accesses FSx for Lustre file systems</a>.
     * </p>
     *
     * @param createLocationFsxLustreRequest
     * @return Result of the CreateLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxLustreResponse createLocationFsxLustre(CreateLocationFsxLustreRequest createLocationFsxLustreRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Lustre file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access"
     * >accesses FSx for Lustre file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxLustreRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxLustreRequest#builder()}
     * </p>
     *
     * @param createLocationFsxLustreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxLustreResponse createLocationFsxLustre(
            Consumer<CreateLocationFsxLustreRequest.Builder> createLocationFsxLustreRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationFsxLustre(CreateLocationFsxLustreRequest.builder().applyMutation(createLocationFsxLustreRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access"
     * >accesses FSx for ONTAP file systems</a>.
     * </p>
     *
     * @param createLocationFsxOntapRequest
     * @return Result of the CreateLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxOntapResponse createLocationFsxOntap(CreateLocationFsxOntapRequest createLocationFsxOntapRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access"
     * >accesses FSx for ONTAP file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxOntapRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLocationFsxOntapRequest#builder()}
     * </p>
     *
     * @param createLocationFsxOntapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxOntapResponse createLocationFsxOntap(
            Consumer<CreateLocationFsxOntapRequest.Builder> createLocationFsxOntapRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationFsxOntap(CreateLocationFsxOntapRequest.builder().applyMutation(createLocationFsxOntapRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for OpenZFS file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access"
     * >accesses FSx for OpenZFS file systems</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>CreateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note>
     *
     * @param createLocationFsxOpenZfsRequest
     * @return Result of the CreateLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxOpenZfsResponse createLocationFsxOpenZfs(
            CreateLocationFsxOpenZfsRequest createLocationFsxOpenZfsRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for OpenZFS file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access"
     * >accesses FSx for OpenZFS file systems</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>CreateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxOpenZfsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxOpenZfsRequest#builder()}
     * </p>
     *
     * @param createLocationFsxOpenZfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxOpenZfsResponse createLocationFsxOpenZfs(
            Consumer<CreateLocationFsxOpenZfsRequest.Builder> createLocationFsxOpenZfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationFsxOpenZfs(CreateLocationFsxOpenZfsRequest.builder().applyMutation(createLocationFsxOpenZfsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Windows File Server file system. DataSync can use this
     * location as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access"
     * >accesses FSx for Windows File Server file systems</a>.
     * </p>
     *
     * @param createLocationFsxWindowsRequest
     * @return Result of the CreateLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxWindowsResponse createLocationFsxWindows(
            CreateLocationFsxWindowsRequest createLocationFsxWindowsRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Windows File Server file system. DataSync can use this
     * location as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access"
     * >accesses FSx for Windows File Server file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxWindowsRequest#builder()}
     * </p>
     *
     * @param createLocationFsxWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationFsxWindowsResponse createLocationFsxWindows(
            Consumer<CreateLocationFsxWindowsRequest.Builder> createLocationFsxWindowsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationFsxWindows(CreateLocationFsxWindowsRequest.builder().applyMutation(createLocationFsxWindowsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Hadoop Distributed File System (HDFS). DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs">accesses
     * HDFS clusters</a>.
     * </p>
     *
     * @param createLocationHdfsRequest
     * @return Result of the CreateLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationHdfsResponse createLocationHdfs(CreateLocationHdfsRequest createLocationHdfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Hadoop Distributed File System (HDFS). DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs">accesses
     * HDFS clusters</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLocationHdfsRequest#builder()}
     * </p>
     *
     * @param createLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationHdfsResponse createLocationHdfs(Consumer<CreateLocationHdfsRequest.Builder> createLocationHdfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationHdfs(CreateLocationHdfsRequest.builder().applyMutation(createLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Network File System (NFS) file server. DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">accesses NFS
     * file servers</a>.
     * </p>
     *
     * @param createLocationNfsRequest
     *        CreateLocationNfsRequest
     * @return Result of the CreateLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationNfsResponse createLocationNfs(CreateLocationNfsRequest createLocationNfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Network File System (NFS) file server. DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">accesses NFS
     * file servers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationNfsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationNfsRequest#builder()}
     * </p>
     *
     * @param createLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest.Builder} to create a
     *        request. CreateLocationNfsRequest
     * @return Result of the CreateLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationNfsResponse createLocationNfs(Consumer<CreateLocationNfsRequest.Builder> createLocationNfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationNfs(CreateLocationNfsRequest.builder().applyMutation(createLocationNfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an object storage system. DataSync can use this location as a source or
     * destination for transferring data. You can make transfers with or without a <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#when-agent-required"
     * >DataSync agent</a>.
     * </p>
     * <p>
     * Before you begin, make sure that you understand the <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites"
     * >prerequisites</a> for DataSync to work with object storage systems.
     * </p>
     *
     * @param createLocationObjectStorageRequest
     *        CreateLocationObjectStorageRequest
     * @return Result of the CreateLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationObjectStorageResponse createLocationObjectStorage(
            CreateLocationObjectStorageRequest createLocationObjectStorageRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an object storage system. DataSync can use this location as a source or
     * destination for transferring data. You can make transfers with or without a <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#when-agent-required"
     * >DataSync agent</a>.
     * </p>
     * <p>
     * Before you begin, make sure that you understand the <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites"
     * >prerequisites</a> for DataSync to work with object storage systems.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param createLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest.Builder} to
     *        create a request. CreateLocationObjectStorageRequest
     * @return Result of the CreateLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocationObjectStorageResponse createLocationObjectStorage(
            Consumer<CreateLocationObjectStorageRequest.Builder> createLocationObjectStorageRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationObjectStorage(CreateLocationObjectStorageRequest.builder()
                .applyMutation(createLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon S3 bucket. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html">Configuring transfers with
     * Amazon S3</a>.
     * </p>
     *
     * @param createLocationS3Request
     *        CreateLocationS3Request
     * @return Result of the CreateLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLocationS3Response createLocationS3(CreateLocationS3Request createLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon S3 bucket. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html">Configuring transfers with
     * Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationS3Request.Builder} avoiding the need
     * to create one manually via {@link CreateLocationS3Request#builder()}
     * </p>
     *
     * @param createLocationS3Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationS3Request.Builder} to create a
     *        request. CreateLocationS3Request
     * @return Result of the CreateLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLocationS3Response createLocationS3(Consumer<CreateLocationS3Request.Builder> createLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationS3(CreateLocationS3Request.builder().applyMutation(createLocationS3Request).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Server Message Block (SMB) file server. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync accesses SMB file servers. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions"
     * >Providing DataSync access to SMB file servers</a>.
     * </p>
     *
     * @param createLocationSmbRequest
     *        CreateLocationSmbRequest
     * @return Result of the CreateLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationSmbResponse createLocationSmb(CreateLocationSmbRequest createLocationSmbRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Server Message Block (SMB) file server. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync accesses SMB file servers. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions"
     * >Providing DataSync access to SMB file servers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationSmbRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationSmbRequest#builder()}
     * </p>
     *
     * @param createLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest.Builder} to create a
     *        request. CreateLocationSmbRequest
     * @return Result of the CreateLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocationSmbResponse createLocationSmb(Consumer<CreateLocationSmbRequest.Builder> createLocationSmbRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createLocationSmb(CreateLocationSmbRequest.builder().applyMutation(createLocationSmbRequest).build());
    }

    /**
     * <p>
     * Configures a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <p>
     * A task includes a source location, destination location, and transfer options (such as bandwidth limits,
     * scheduling, and more).
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important>
     *
     * @param createTaskRequest
     *        CreateTaskRequest
     * @return Result of the CreateTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTaskResponse createTask(CreateTaskRequest createTaskRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <p>
     * A task includes a source location, destination location, and transfer options (such as bandwidth limits,
     * scheduling, and more).
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTaskRequest#builder()}
     * </p>
     *
     * @param createTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateTaskRequest.Builder} to create a request.
     *        CreateTaskRequest
     * @return Result of the CreateTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTaskResponse createTask(Consumer<CreateTaskRequest.Builder> createTaskRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return createTask(CreateTaskRequest.builder().applyMutation(createTaskRequest).build());
    }

    /**
     * <p>
     * Removes an DataSync agent resource from your Amazon Web Services account.
     * </p>
     * <p>
     * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or
     * Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your
     * storage environment or reuse it to <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activate a new agent</a>.
     * </p>
     *
     * @param deleteAgentRequest
     *        DeleteAgentRequest
     * @return Result of the DeleteAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAgentResponse deleteAgent(DeleteAgentRequest deleteAgentRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an DataSync agent resource from your Amazon Web Services account.
     * </p>
     * <p>
     * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or
     * Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your
     * storage environment or reuse it to <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activate a new agent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAgentRequest#builder()}
     * </p>
     *
     * @param deleteAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteAgentRequest.Builder} to create a request.
     *        DeleteAgentRequest
     * @return Result of the DeleteAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAgentResponse deleteAgent(Consumer<DeleteAgentRequest.Builder> deleteAgentRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return deleteAgent(DeleteAgentRequest.builder().applyMutation(deleteAgentRequest).build());
    }

    /**
     * <p>
     * Deletes a transfer location resource from DataSync.
     * </p>
     *
     * @param deleteLocationRequest
     *        DeleteLocation
     * @return Result of the DeleteLocation operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLocationResponse deleteLocation(DeleteLocationRequest deleteLocationRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transfer location resource from DataSync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocationRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLocationRequest#builder()}
     * </p>
     *
     * @param deleteLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteLocationRequest.Builder} to create a request.
     *        DeleteLocation
     * @return Result of the DeleteLocation operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLocationResponse deleteLocation(Consumer<DeleteLocationRequest.Builder> deleteLocationRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return deleteLocation(DeleteLocationRequest.builder().applyMutation(deleteLocationRequest).build());
    }

    /**
     * <p>
     * Deletes a transfer task resource from DataSync.
     * </p>
     *
     * @param deleteTaskRequest
     *        DeleteTask
     * @return Result of the DeleteTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTaskResponse deleteTask(DeleteTaskRequest deleteTaskRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transfer task resource from DataSync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTaskRequest#builder()}
     * </p>
     *
     * @param deleteTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteTaskRequest.Builder} to create a request.
     *        DeleteTask
     * @return Result of the DeleteTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DeleteTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTaskResponse deleteTask(Consumer<DeleteTaskRequest.Builder> deleteTaskRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return deleteTask(DeleteTaskRequest.builder().applyMutation(deleteTaskRequest).build());
    }

    /**
     * <p>
     * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
     * </p>
     *
     * @param describeAgentRequest
     *        DescribeAgent
     * @return Result of the DescribeAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAgentResponse describeAgent(DescribeAgentRequest describeAgentRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAgentRequest#builder()}
     * </p>
     *
     * @param describeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeAgentRequest.Builder} to create a request.
     *        DescribeAgent
     * @return Result of the DescribeAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAgentResponse describeAgent(Consumer<DescribeAgentRequest.Builder> describeAgentRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeAgent(DescribeAgentRequest.builder().applyMutation(describeAgentRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
     * </p>
     *
     * @param describeLocationAzureBlobRequest
     * @return Result of the DescribeLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationAzureBlobResponse describeLocationAzureBlob(
            DescribeLocationAzureBlobRequest describeLocationAzureBlobRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param describeLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationAzureBlobResponse describeLocationAzureBlob(
            Consumer<DescribeLocationAzureBlobRequest.Builder> describeLocationAzureBlobRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationAzureBlob(DescribeLocationAzureBlobRequest.builder()
                .applyMutation(describeLocationAzureBlobRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
     * </p>
     *
     * @param describeLocationEfsRequest
     *        DescribeLocationEfsRequest
     * @return Result of the DescribeLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationEfsResponse describeLocationEfs(DescribeLocationEfsRequest describeLocationEfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationEfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationEfsRequest#builder()}
     * </p>
     *
     * @param describeLocationEfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest.Builder} to create a
     *        request. DescribeLocationEfsRequest
     * @return Result of the DescribeLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationEfsResponse describeLocationEfs(
            Consumer<DescribeLocationEfsRequest.Builder> describeLocationEfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationEfs(DescribeLocationEfsRequest.builder().applyMutation(describeLocationEfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
     * </p>
     *
     * @param describeLocationFsxLustreRequest
     * @return Result of the DescribeLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxLustreResponse describeLocationFsxLustre(
            DescribeLocationFsxLustreRequest describeLocationFsxLustreRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxLustreRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxLustreRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxLustreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxLustreResponse describeLocationFsxLustre(
            Consumer<DescribeLocationFsxLustreRequest.Builder> describeLocationFsxLustreRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationFsxLustre(DescribeLocationFsxLustreRequest.builder()
                .applyMutation(describeLocationFsxLustreRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is
     * configured.
     * </p>
     * <note>
     * <p>
     * If your location uses SMB, the <code>DescribeLocationFsxOntap</code> operation doesn't actually return a
     * <code>Password</code>.
     * </p>
     * </note>
     *
     * @param describeLocationFsxOntapRequest
     * @return Result of the DescribeLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxOntapResponse describeLocationFsxOntap(
            DescribeLocationFsxOntapRequest describeLocationFsxOntapRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is
     * configured.
     * </p>
     * <note>
     * <p>
     * If your location uses SMB, the <code>DescribeLocationFsxOntap</code> operation doesn't actually return a
     * <code>Password</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxOntapRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxOntapRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxOntapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxOntapResponse describeLocationFsxOntap(
            Consumer<DescribeLocationFsxOntapRequest.Builder> describeLocationFsxOntapRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationFsxOntap(DescribeLocationFsxOntapRequest.builder().applyMutation(describeLocationFsxOntapRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
     * </p>
     * <note>
     * <p>
     * Response elements related to <code>SMB</code> aren't supported with the <code>DescribeLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note>
     *
     * @param describeLocationFsxOpenZfsRequest
     * @return Result of the DescribeLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxOpenZfsResponse describeLocationFsxOpenZfs(
            DescribeLocationFsxOpenZfsRequest describeLocationFsxOpenZfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
     * </p>
     * <note>
     * <p>
     * Response elements related to <code>SMB</code> aren't supported with the <code>DescribeLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxOpenZfsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxOpenZfsRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxOpenZfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxOpenZfsResponse describeLocationFsxOpenZfs(
            Consumer<DescribeLocationFsxOpenZfsRequest.Builder> describeLocationFsxOpenZfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationFsxOpenZfs(DescribeLocationFsxOpenZfsRequest.builder()
                .applyMutation(describeLocationFsxOpenZfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is
     * configured.
     * </p>
     *
     * @param describeLocationFsxWindowsRequest
     * @return Result of the DescribeLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxWindowsResponse describeLocationFsxWindows(
            DescribeLocationFsxWindowsRequest describeLocationFsxWindowsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxWindowsRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationFsxWindowsResponse describeLocationFsxWindows(
            Consumer<DescribeLocationFsxWindowsRequest.Builder> describeLocationFsxWindowsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationFsxWindows(DescribeLocationFsxWindowsRequest.builder()
                .applyMutation(describeLocationFsxWindowsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is
     * configured.
     * </p>
     *
     * @param describeLocationHdfsRequest
     * @return Result of the DescribeLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationHdfsResponse describeLocationHdfs(DescribeLocationHdfsRequest describeLocationHdfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationHdfsRequest#builder()}
     * </p>
     *
     * @param describeLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationHdfsResponse describeLocationHdfs(
            Consumer<DescribeLocationHdfsRequest.Builder> describeLocationHdfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationHdfs(DescribeLocationHdfsRequest.builder().applyMutation(describeLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is
     * configured.
     * </p>
     *
     * @param describeLocationNfsRequest
     *        DescribeLocationNfsRequest
     * @return Result of the DescribeLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationNfsResponse describeLocationNfs(DescribeLocationNfsRequest describeLocationNfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationNfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationNfsRequest#builder()}
     * </p>
     *
     * @param describeLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest.Builder} to create a
     *        request. DescribeLocationNfsRequest
     * @return Result of the DescribeLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationNfsResponse describeLocationNfs(
            Consumer<DescribeLocationNfsRequest.Builder> describeLocationNfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationNfs(DescribeLocationNfsRequest.builder().applyMutation(describeLocationNfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an object storage system is configured.
     * </p>
     *
     * @param describeLocationObjectStorageRequest
     *        DescribeLocationObjectStorageRequest
     * @return Result of the DescribeLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationObjectStorageResponse describeLocationObjectStorage(
            DescribeLocationObjectStorageRequest describeLocationObjectStorageRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an object storage system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param describeLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest.Builder} to
     *        create a request. DescribeLocationObjectStorageRequest
     * @return Result of the DescribeLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationObjectStorageResponse describeLocationObjectStorage(
            Consumer<DescribeLocationObjectStorageRequest.Builder> describeLocationObjectStorageRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationObjectStorage(DescribeLocationObjectStorageRequest.builder()
                .applyMutation(describeLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an S3 bucket is configured.
     * </p>
     *
     * @param describeLocationS3Request
     *        DescribeLocationS3Request
     * @return Result of the DescribeLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationS3Response describeLocationS3(DescribeLocationS3Request describeLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an S3 bucket is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationS3Request.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationS3Request#builder()}
     * </p>
     *
     * @param describeLocationS3Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request.Builder} to create a
     *        request. DescribeLocationS3Request
     * @return Result of the DescribeLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationS3Response describeLocationS3(Consumer<DescribeLocationS3Request.Builder> describeLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationS3(DescribeLocationS3Request.builder().applyMutation(describeLocationS3Request).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is
     * configured.
     * </p>
     *
     * @param describeLocationSmbRequest
     *        DescribeLocationSmbRequest
     * @return Result of the DescribeLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationSmbResponse describeLocationSmb(DescribeLocationSmbRequest describeLocationSmbRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationSmbRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationSmbRequest#builder()}
     * </p>
     *
     * @param describeLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest.Builder} to create a
     *        request. DescribeLocationSmbRequest
     * @return Result of the DescribeLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLocationSmbResponse describeLocationSmb(
            Consumer<DescribeLocationSmbRequest.Builder> describeLocationSmbRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeLocationSmb(DescribeLocationSmbRequest.builder().applyMutation(describeLocationSmbRequest).build());
    }

    /**
     * <p>
     * Provides information about a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     *
     * @param describeTaskRequest
     *        DescribeTaskRequest
     * @return Result of the DescribeTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTaskResponse describeTask(DescribeTaskRequest describeTaskRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTaskRequest#builder()}
     * </p>
     *
     * @param describeTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeTaskRequest.Builder} to create a request.
     *        DescribeTaskRequest
     * @return Result of the DescribeTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTaskResponse describeTask(Consumer<DescribeTaskRequest.Builder> describeTaskRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeTask(DescribeTaskRequest.builder().applyMutation(describeTaskRequest).build());
    }

    /**
     * <p>
     * Provides information about an execution of your DataSync task. You can use this operation to help monitor the
     * progress of an ongoing data transfer or check the results of the transfer.
     * </p>
     * <note>
     * <p>
     * Some <code>DescribeTaskExecution</code> response elements are only relevant to a specific task mode. For
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html#task-mode-differences"
     * >Understanding task mode differences</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/transfer-performance-counters.html">Understanding
     * data transfer performance counters</a>.
     * </p>
     * </note>
     *
     * @param describeTaskExecutionRequest
     *        DescribeTaskExecutionRequest
     * @return Result of the DescribeTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTaskExecutionResponse describeTaskExecution(DescribeTaskExecutionRequest describeTaskExecutionRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an execution of your DataSync task. You can use this operation to help monitor the
     * progress of an ongoing data transfer or check the results of the transfer.
     * </p>
     * <note>
     * <p>
     * Some <code>DescribeTaskExecution</code> response elements are only relevant to a specific task mode. For
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html#task-mode-differences"
     * >Understanding task mode differences</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/transfer-performance-counters.html">Understanding
     * data transfer performance counters</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTaskExecutionRequest#builder()}
     * </p>
     *
     * @param describeTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest.Builder} to create a
     *        request. DescribeTaskExecutionRequest
     * @return Result of the DescribeTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.DescribeTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTaskExecutionResponse describeTaskExecution(
            Consumer<DescribeTaskExecutionRequest.Builder> describeTaskExecutionRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return describeTaskExecution(DescribeTaskExecutionRequest.builder().applyMutation(describeTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     *
     * @param listAgentsRequest
     *        ListAgentsRequest
     * @return Result of the ListAgents operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsResponse listAgents(ListAgentsRequest listAgentsRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListAgentsRequest.Builder} to create a request.
     *        ListAgentsRequest
     * @return Result of the ListAgents operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsResponse listAgents(Consumer<ListAgentsRequest.Builder> listAgentsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listAgents(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     *
     * @return Result of the ListAgents operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see #listAgents(ListAgentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsResponse listAgents() throws InvalidRequestException, InternalException, AwsServiceException,
            SdkClientException, DataSyncException {
        return listAgents(ListAgentsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see #listAgentsPaginator(ListAgentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsIterable listAgentsPaginator() throws InvalidRequestException, InternalException, AwsServiceException,
            SdkClientException, DataSyncException {
        return listAgentsPaginator(ListAgentsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     *
     * @param listAgentsRequest
     *        ListAgentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsIterable listAgentsPaginator(ListAgentsRequest listAgentsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListAgentsIterable(this, listAgentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable responses = client.listAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListAgentsRequest.Builder} to create a request.
     *        ListAgentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsIterable listAgentsPaginator(Consumer<ListAgentsRequest.Builder> listAgentsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listAgentsPaginator(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     *
     * @param listLocationsRequest
     *        ListLocationsRequest
     * @return Result of the ListLocations operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsResponse listLocations(ListLocationsRequest listLocationsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListLocationsRequest.Builder} to create a request.
     *        ListLocationsRequest
     * @return Result of the ListLocations operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsResponse listLocations(Consumer<ListLocationsRequest.Builder> listLocationsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listLocations(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     *
     * @return Result of the ListLocations operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see #listLocations(ListLocationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsResponse listLocations() throws InvalidRequestException, InternalException, AwsServiceException,
            SdkClientException, DataSyncException {
        return listLocations(ListLocationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see #listLocationsPaginator(ListLocationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsIterable listLocationsPaginator() throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        return listLocationsPaginator(ListLocationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @param listLocationsRequest
     *        ListLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsIterable listLocationsPaginator(ListLocationsRequest listLocationsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListLocationsIterable(this, listLocationsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListLocationsRequest.Builder} to create a request.
     *        ListLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsIterable listLocationsPaginator(Consumer<ListLocationsRequest.Builder> listLocationsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listLocationsPaginator(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Returns all the tags associated with an Amazon Web Services resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the tags associated with an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest.Builder} to create a
     *        request. ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest.Builder} to create a
     *        request. ListTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        ListTaskExecutions
     * @return Result of the ListTaskExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsResponse listTaskExecutions(ListTaskExecutionsRequest listTaskExecutionsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest.Builder} to create a
     *        request. ListTaskExecutions
     * @return Result of the ListTaskExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsResponse listTaskExecutions(Consumer<ListTaskExecutionsRequest.Builder> listTaskExecutionsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTaskExecutions(ListTaskExecutionsRequest.builder().applyMutation(listTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     *
     * @return Result of the ListTaskExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see #listTaskExecutions(ListTaskExecutionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsResponse listTaskExecutions() throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        return listTaskExecutions(ListTaskExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client
     *             .listTaskExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see #listTaskExecutionsPaginator(ListTaskExecutionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsIterable listTaskExecutionsPaginator() throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        return listTaskExecutionsPaginator(ListTaskExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client
     *             .listTaskExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        ListTaskExecutions
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsIterable listTaskExecutionsPaginator(ListTaskExecutionsRequest listTaskExecutionsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTaskExecutionsIterable(this, listTaskExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client
     *             .listTaskExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable responses = client.listTaskExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest.Builder} to create a
     *        request. ListTaskExecutions
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsIterable listTaskExecutionsPaginator(
            Consumer<ListTaskExecutionsRequest.Builder> listTaskExecutionsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTaskExecutionsPaginator(ListTaskExecutionsRequest.builder().applyMutation(listTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     *
     * @param listTasksRequest
     *        ListTasksRequest
     * @return Result of the ListTasks operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTasksRequest.Builder} to create a request.
     *        ListTasksRequest
     * @return Result of the ListTasks operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksResponse listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     *
     * @return Result of the ListTasks operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see #listTasks(ListTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksResponse listTasks() throws InvalidRequestException, InternalException, AwsServiceException,
            SdkClientException, DataSyncException {
        return listTasks(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see #listTasksPaginator(ListTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksIterable listTasksPaginator() throws InvalidRequestException, InternalException, AwsServiceException,
            SdkClientException, DataSyncException {
        return listTasksPaginator(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     *        ListTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(ListTasksRequest listTasksRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTasksIterable(this, listTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.datasync.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTasksRequest.Builder} to create a request.
     *        ListTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
     * </p>
     * <p>
     * There are several steps to a task execution. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important>
     *
     * @param startTaskExecutionRequest
     *        StartTaskExecutionRequest
     * @return Result of the StartTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.StartTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default StartTaskExecutionResponse startTaskExecution(StartTaskExecutionRequest startTaskExecutionRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
     * </p>
     * <p>
     * There are several steps to a task execution. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartTaskExecutionRequest#builder()}
     * </p>
     *
     * @param startTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest.Builder} to create a
     *        request. StartTaskExecutionRequest
     * @return Result of the StartTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.StartTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default StartTaskExecutionResponse startTaskExecution(Consumer<StartTaskExecutionRequest.Builder> startTaskExecutionRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return startTaskExecution(StartTaskExecutionRequest.builder().applyMutation(startTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Applies a <i>tag</i> to an Amazon Web Services resource. Tags are key-value pairs that can help you manage,
     * filter, and search for your resources.
     * </p>
     * <p>
     * These include DataSync resources, such as locations, tasks, and task executions.
     * </p>
     *
     * @param tagResourceRequest
     *        TagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a <i>tag</i> to an Amazon Web Services resource. Tags are key-value pairs that can help you manage,
     * filter, and search for your resources.
     * </p>
     * <p>
     * These include DataSync resources, such as locations, tasks, and task executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.TagResourceRequest.Builder} to create a request.
     *        TagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     *        UntagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UntagResourceRequest.Builder} to create a request.
     *        UntagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name of an DataSync agent.
     * </p>
     *
     * @param updateAgentRequest
     *        UpdateAgentRequest
     * @return Result of the UpdateAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgentResponse updateAgent(UpdateAgentRequest updateAgentRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of an DataSync agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAgentRequest#builder()}
     * </p>
     *
     * @param updateAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateAgentRequest.Builder} to create a request.
     *        UpdateAgentRequest
     * @return Result of the UpdateAgent operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgentResponse updateAgent(Consumer<UpdateAgentRequest.Builder> updateAgentRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateAgent(UpdateAgentRequest.builder().applyMutation(updateAgentRequest).build());
    }

    /**
     * <p>
     * Modifies the following configurations of the Microsoft Azure Blob Storage transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html">Configuring
     * DataSync transfers with Azure Blob Storage</a>.
     * </p>
     *
     * @param updateLocationAzureBlobRequest
     * @return Result of the UpdateLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationAzureBlobResponse updateLocationAzureBlob(UpdateLocationAzureBlobRequest updateLocationAzureBlobRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configurations of the Microsoft Azure Blob Storage transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html">Configuring
     * DataSync transfers with Azure Blob Storage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param updateLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationAzureBlob operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationAzureBlobResponse updateLocationAzureBlob(
            Consumer<UpdateLocationAzureBlobRequest.Builder> updateLocationAzureBlobRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationAzureBlob(UpdateLocationAzureBlobRequest.builder().applyMutation(updateLocationAzureBlobRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon EFS transfer location that you're using with
     * DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html">Configuring DataSync
     * transfers with Amazon EFS</a>.
     * </p>
     *
     * @param updateLocationEfsRequest
     * @return Result of the UpdateLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationEfsResponse updateLocationEfs(UpdateLocationEfsRequest updateLocationEfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon EFS transfer location that you're using with
     * DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html">Configuring DataSync
     * transfers with Amazon EFS</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationEfsRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationEfsRequest#builder()}
     * </p>
     *
     * @param updateLocationEfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationEfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationEfsResponse updateLocationEfs(Consumer<UpdateLocationEfsRequest.Builder> updateLocationEfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationEfs(UpdateLocationEfsRequest.builder().applyMutation(updateLocationEfsRequest).build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for Lustre transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html">Configuring DataSync
     * transfers with FSx for Lustre</a>.
     * </p>
     *
     * @param updateLocationFsxLustreRequest
     * @return Result of the UpdateLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxLustreResponse updateLocationFsxLustre(UpdateLocationFsxLustreRequest updateLocationFsxLustreRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for Lustre transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html">Configuring DataSync
     * transfers with FSx for Lustre</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationFsxLustreRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLocationFsxLustreRequest#builder()}
     * </p>
     *
     * @param updateLocationFsxLustreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationFsxLustre operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxLustreResponse updateLocationFsxLustre(
            Consumer<UpdateLocationFsxLustreRequest.Builder> updateLocationFsxLustreRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationFsxLustre(UpdateLocationFsxLustreRequest.builder().applyMutation(updateLocationFsxLustreRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for NetApp ONTAP transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html">Configuring DataSync
     * transfers with FSx for ONTAP</a>.
     * </p>
     *
     * @param updateLocationFsxOntapRequest
     * @return Result of the UpdateLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxOntapResponse updateLocationFsxOntap(UpdateLocationFsxOntapRequest updateLocationFsxOntapRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for NetApp ONTAP transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html">Configuring DataSync
     * transfers with FSx for ONTAP</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationFsxOntapRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLocationFsxOntapRequest#builder()}
     * </p>
     *
     * @param updateLocationFsxOntapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationFsxOntap operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxOntapResponse updateLocationFsxOntap(
            Consumer<UpdateLocationFsxOntapRequest.Builder> updateLocationFsxOntapRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationFsxOntap(UpdateLocationFsxOntapRequest.builder().applyMutation(updateLocationFsxOntapRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for OpenZFS transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html">Configuring DataSync
     * transfers with FSx for OpenZFS</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>UpdateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note>
     *
     * @param updateLocationFsxOpenZfsRequest
     * @return Result of the UpdateLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxOpenZfsResponse updateLocationFsxOpenZfs(
            UpdateLocationFsxOpenZfsRequest updateLocationFsxOpenZfsRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for OpenZFS transfer location that you're using
     * with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html">Configuring DataSync
     * transfers with FSx for OpenZFS</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>UpdateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationFsxOpenZfsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLocationFsxOpenZfsRequest#builder()}
     * </p>
     *
     * @param updateLocationFsxOpenZfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationFsxOpenZfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxOpenZfsResponse updateLocationFsxOpenZfs(
            Consumer<UpdateLocationFsxOpenZfsRequest.Builder> updateLocationFsxOpenZfsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationFsxOpenZfs(UpdateLocationFsxOpenZfsRequest.builder().applyMutation(updateLocationFsxOpenZfsRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for Windows File Server transfer location that
     * you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html">Configuring DataSync
     * transfers with FSx for Windows File Server</a>.
     * </p>
     *
     * @param updateLocationFsxWindowsRequest
     * @return Result of the UpdateLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxWindowsResponse updateLocationFsxWindows(
            UpdateLocationFsxWindowsRequest updateLocationFsxWindowsRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon FSx for Windows File Server transfer location that
     * you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html">Configuring DataSync
     * transfers with FSx for Windows File Server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationFsxWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLocationFsxWindowsRequest#builder()}
     * </p>
     *
     * @param updateLocationFsxWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationFsxWindows operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationFsxWindowsResponse updateLocationFsxWindows(
            Consumer<UpdateLocationFsxWindowsRequest.Builder> updateLocationFsxWindowsRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationFsxWindows(UpdateLocationFsxWindowsRequest.builder().applyMutation(updateLocationFsxWindowsRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Hadoop Distributed File System (HDFS) transfer location
     * that you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html">Configuring DataSync
     * transfers with an HDFS cluster</a>.
     * </p>
     *
     * @param updateLocationHdfsRequest
     * @return Result of the UpdateLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationHdfsResponse updateLocationHdfs(UpdateLocationHdfsRequest updateLocationHdfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Hadoop Distributed File System (HDFS) transfer location
     * that you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html">Configuring DataSync
     * transfers with an HDFS cluster</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLocationHdfsRequest#builder()}
     * </p>
     *
     * @param updateLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationHdfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationHdfsResponse updateLocationHdfs(Consumer<UpdateLocationHdfsRequest.Builder> updateLocationHdfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationHdfs(UpdateLocationHdfsRequest.builder().applyMutation(updateLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Network File System (NFS) transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Configuring transfers with
     * an NFS file server</a>.
     * </p>
     *
     * @param updateLocationNfsRequest
     * @return Result of the UpdateLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationNfsResponse updateLocationNfs(UpdateLocationNfsRequest updateLocationNfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Network File System (NFS) transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Configuring transfers with
     * an NFS file server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationNfsRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationNfsRequest#builder()}
     * </p>
     *
     * @param updateLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationNfs operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationNfsResponse updateLocationNfs(Consumer<UpdateLocationNfsRequest.Builder> updateLocationNfsRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationNfs(UpdateLocationNfsRequest.builder().applyMutation(updateLocationNfsRequest).build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the object storage transfer location that you're using with
     * DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Configuring DataSync
     * transfers with an object storage system</a>.
     * </p>
     *
     * @param updateLocationObjectStorageRequest
     * @return Result of the UpdateLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationObjectStorageResponse updateLocationObjectStorage(
            UpdateLocationObjectStorageRequest updateLocationObjectStorageRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the object storage transfer location that you're using with
     * DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Configuring DataSync
     * transfers with an object storage system</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param updateLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLocationObjectStorage operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLocationObjectStorageResponse updateLocationObjectStorage(
            Consumer<UpdateLocationObjectStorageRequest.Builder> updateLocationObjectStorageRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationObjectStorage(UpdateLocationObjectStorageRequest.builder()
                .applyMutation(updateLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon S3 transfer location that you're using with
     * DataSync.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param updateLocationS3Request
     * @return Result of the UpdateLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLocationS3Response updateLocationS3(UpdateLocationS3Request updateLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Amazon S3 transfer location that you're using with
     * DataSync.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationS3Request.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationS3Request#builder()}
     * </p>
     *
     * @param updateLocationS3Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationS3 operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLocationS3Response updateLocationS3(Consumer<UpdateLocationS3Request.Builder> updateLocationS3Request)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationS3(UpdateLocationS3Request.builder().applyMutation(updateLocationS3Request).build());
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Server Message Block (SMB) transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html">Configuring DataSync
     * transfers with an SMB file server</a>.
     * </p>
     *
     * @param updateLocationSmbRequest
     * @return Result of the UpdateLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationSmbResponse updateLocationSmb(UpdateLocationSmbRequest updateLocationSmbRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the following configuration parameters of the Server Message Block (SMB) transfer location that you're
     * using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html">Configuring DataSync
     * transfers with an SMB file server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationSmbRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationSmbRequest#builder()}
     * </p>
     *
     * @param updateLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLocationSmb operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLocationSmbResponse updateLocationSmb(Consumer<UpdateLocationSmbRequest.Builder> updateLocationSmbRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateLocationSmb(UpdateLocationSmbRequest.builder().applyMutation(updateLocationSmbRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     *
     * @param updateTaskRequest
     *        UpdateTaskResponse
     * @return Result of the UpdateTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTaskResponse updateTask(UpdateTaskRequest updateTaskRequest) throws InvalidRequestException, InternalException,
            AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTaskRequest#builder()}
     * </p>
     *
     * @param updateTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateTaskRequest.Builder} to create a request.
     *        UpdateTaskResponse
     * @return Result of the UpdateTask operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTaskResponse updateTask(Consumer<UpdateTaskRequest.Builder> updateTaskRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateTask(UpdateTaskRequest.builder().applyMutation(updateTaskRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a running DataSync task execution.
     * </p>
     * <note>
     * <p>
     * Currently, the only <code>Option</code> that you can modify with <code>UpdateTaskExecution</code> is
     * <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>
     * , which throttles bandwidth for a running or queued task execution.
     * </p>
     * </note>
     *
     * @param updateTaskExecutionRequest
     * @return Result of the UpdateTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTaskExecutionResponse updateTaskExecution(UpdateTaskExecutionRequest updateTaskExecutionRequest)
            throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a running DataSync task execution.
     * </p>
     * <note>
     * <p>
     * Currently, the only <code>Option</code> that you can modify with <code>UpdateTaskExecution</code> is
     * <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>
     * , which throttles bandwidth for a running or queued task execution.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTaskExecutionRequest#builder()}
     * </p>
     *
     * @param updateTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTaskExecution operation returned by the service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws InternalException
     *         This exception is thrown when an error occurs in the DataSync service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataSyncClient.UpdateTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTaskExecutionResponse updateTaskExecution(
            Consumer<UpdateTaskExecutionRequest.Builder> updateTaskExecutionRequest) throws InvalidRequestException,
            InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return updateTaskExecution(UpdateTaskExecutionRequest.builder().applyMutation(updateTaskExecutionRequest).build());
    }

    /**
     * Create a {@link DataSyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataSyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataSyncClient}.
     */
    static DataSyncClientBuilder builder() {
        return new DefaultDataSyncClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DataSyncServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
