/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomSecretConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomSecretConfig> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(CustomSecretConfig.getter(CustomSecretConfig::secretArn)).setter(CustomSecretConfig.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SECRET_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretAccessRoleArn").getter(CustomSecretConfig.getter(CustomSecretConfig::secretAccessRoleArn)).setter(CustomSecretConfig.setter(Builder::secretAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, SECRET_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomSecretConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secretArn;
    private final String secretAccessRoleArn;

    private CustomSecretConfig(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.secretAccessRoleArn = builder.secretAccessRoleArn;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String secretAccessRoleArn() {
        return this.secretAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomSecretConfig)) {
            return false;
        }
        CustomSecretConfig other = (CustomSecretConfig)obj;
        return Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.secretAccessRoleArn(), other.secretAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CustomSecretConfig").add("SecretArn", (Object)this.secretArn()).add("SecretAccessRoleArn", (Object)this.secretAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SecretAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SecretAccessRoleArn", SECRET_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomSecretConfig, T> g) {
        return obj -> g.apply((CustomSecretConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretArn;
        private String secretAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomSecretConfig model) {
            this.secretArn(model.secretArn);
            this.secretAccessRoleArn(model.secretAccessRoleArn);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSecretAccessRoleArn() {
            return this.secretAccessRoleArn;
        }

        public final void setSecretAccessRoleArn(String secretAccessRoleArn) {
            this.secretAccessRoleArn = secretAccessRoleArn;
        }

        @Override
        public final Builder secretAccessRoleArn(String secretAccessRoleArn) {
            this.secretAccessRoleArn = secretAccessRoleArn;
            return this;
        }

        public CustomSecretConfig build() {
            return new CustomSecretConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomSecretConfig> {
        public Builder secretArn(String var1);

        public Builder secretAccessRoleArn(String var1);
    }
}

