/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDiscoveryJobRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateDiscoveryJobRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryJobArn").getter(UpdateDiscoveryJobRequest.getter(UpdateDiscoveryJobRequest::discoveryJobArn)).setter(UpdateDiscoveryJobRequest.setter(Builder::discoveryJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()}).build();
    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CollectionDurationMinutes").getter(UpdateDiscoveryJobRequest.getter(UpdateDiscoveryJobRequest::collectionDurationMinutes)).setter(UpdateDiscoveryJobRequest.setter(Builder::collectionDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD, COLLECTION_DURATION_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDiscoveryJobRequest.memberNameToFieldInitializer();
    private final String discoveryJobArn;
    private final Integer collectionDurationMinutes;

    private UpdateDiscoveryJobRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
    }

    public final String discoveryJobArn() {
        return this.discoveryJobArn;
    }

    public final Integer collectionDurationMinutes() {
        return this.collectionDurationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionDurationMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDiscoveryJobRequest)) {
            return false;
        }
        UpdateDiscoveryJobRequest other = (UpdateDiscoveryJobRequest)((Object)obj);
        return Objects.equals(this.discoveryJobArn(), other.discoveryJobArn()) && Objects.equals(this.collectionDurationMinutes(), other.collectionDurationMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDiscoveryJobRequest").add("DiscoveryJobArn", (Object)this.discoveryJobArn()).add("CollectionDurationMinutes", (Object)this.collectionDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscoveryJobArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryJobArn()));
            }
            case "CollectionDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.collectionDurationMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("CollectionDurationMinutes", COLLECTION_DURATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDiscoveryJobRequest, T> g) {
        return obj -> g.apply((UpdateDiscoveryJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String discoveryJobArn;
        private Integer collectionDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDiscoveryJobRequest model) {
            super(model);
            this.discoveryJobArn(model.discoveryJobArn);
            this.collectionDurationMinutes(model.collectionDurationMinutes);
        }

        public final String getDiscoveryJobArn() {
            return this.discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return this.collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDiscoveryJobRequest build() {
            return new UpdateDiscoveryJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDiscoveryJobRequest> {
        public Builder discoveryJobArn(String var1);

        public Builder collectionDurationMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

