/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.DiscoveryAgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration;
import software.amazon.awssdk.services.datasync.model.DiscoverySystemType;
import software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageSystemResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeStorageSystemResponse> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSystemArn").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::storageSystemArn)).setter(DescribeStorageSystemResponse.setter(Builder::storageSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()}).build();
    private static final SdkField<DiscoveryServerConfiguration> SERVER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerConfiguration").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::serverConfiguration)).setter(DescribeStorageSystemResponse.setter(Builder::serverConfiguration)).constructor(DiscoveryServerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerConfiguration").build()}).build();
    private static final SdkField<String> SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SystemType").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::systemTypeAsString)).setter(DescribeStorageSystemResponse.setter(Builder::systemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemType").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::agentArns)).setter(DescribeStorageSystemResponse.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::name)).setter(DescribeStorageSystemResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::errorMessage)).setter(DescribeStorageSystemResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> CONNECTIVITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectivityStatus").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::connectivityStatusAsString)).setter(DescribeStorageSystemResponse.setter(Builder::connectivityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityStatus").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::cloudWatchLogGroupArn)).setter(DescribeStorageSystemResponse.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::creationTime)).setter(DescribeStorageSystemResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerArn").getter(DescribeStorageSystemResponse.getter(DescribeStorageSystemResponse::secretsManagerArn)).setter(DescribeStorageSystemResponse.setter(Builder::secretsManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD, SERVER_CONFIGURATION_FIELD, SYSTEM_TYPE_FIELD, AGENT_ARNS_FIELD, NAME_FIELD, ERROR_MESSAGE_FIELD, CONNECTIVITY_STATUS_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, CREATION_TIME_FIELD, SECRETS_MANAGER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageSystemResponse.memberNameToFieldInitializer();
    private final String storageSystemArn;
    private final DiscoveryServerConfiguration serverConfiguration;
    private final String systemType;
    private final List<String> agentArns;
    private final String name;
    private final String errorMessage;
    private final String connectivityStatus;
    private final String cloudWatchLogGroupArn;
    private final Instant creationTime;
    private final String secretsManagerArn;

    private DescribeStorageSystemResponse(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.serverConfiguration = builder.serverConfiguration;
        this.systemType = builder.systemType;
        this.agentArns = builder.agentArns;
        this.name = builder.name;
        this.errorMessage = builder.errorMessage;
        this.connectivityStatus = builder.connectivityStatus;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.creationTime = builder.creationTime;
        this.secretsManagerArn = builder.secretsManagerArn;
    }

    public final String storageSystemArn() {
        return this.storageSystemArn;
    }

    public final DiscoveryServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public final DiscoverySystemType systemType() {
        return DiscoverySystemType.fromValue(this.systemType);
    }

    public final String systemTypeAsString() {
        return this.systemType;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final String name() {
        return this.name;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final StorageSystemConnectivityStatus connectivityStatus() {
        return StorageSystemConnectivityStatus.fromValue(this.connectivityStatus);
    }

    public final String connectivityStatusAsString() {
        return this.connectivityStatus;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String secretsManagerArn() {
        return this.secretsManagerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResponse)) {
            return false;
        }
        DescribeStorageSystemResponse other = (DescribeStorageSystemResponse)((Object)obj);
        return Objects.equals(this.storageSystemArn(), other.storageSystemArn()) && Objects.equals(this.serverConfiguration(), other.serverConfiguration()) && Objects.equals(this.systemTypeAsString(), other.systemTypeAsString()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.connectivityStatusAsString(), other.connectivityStatusAsString()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.secretsManagerArn(), other.secretsManagerArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageSystemResponse").add("StorageSystemArn", (Object)this.storageSystemArn()).add("ServerConfiguration", (Object)this.serverConfiguration()).add("SystemType", (Object)this.systemTypeAsString()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("Name", (Object)this.name()).add("ErrorMessage", (Object)this.errorMessage()).add("ConnectivityStatus", (Object)this.connectivityStatusAsString()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("CreationTime", (Object)this.creationTime()).add("SecretsManagerArn", (Object)this.secretsManagerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageSystemArn": {
                return Optional.ofNullable(clazz.cast(this.storageSystemArn()));
            }
            case "ServerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverConfiguration()));
            }
            case "SystemType": {
                return Optional.ofNullable(clazz.cast(this.systemTypeAsString()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ConnectivityStatus": {
                return Optional.ofNullable(clazz.cast(this.connectivityStatusAsString()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SecretsManagerArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageSystemArn", STORAGE_SYSTEM_ARN_FIELD);
        map.put("ServerConfiguration", SERVER_CONFIGURATION_FIELD);
        map.put("SystemType", SYSTEM_TYPE_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ConnectivityStatus", CONNECTIVITY_STATUS_FIELD);
        map.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("SecretsManagerArn", SECRETS_MANAGER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResponse, T> g) {
        return obj -> g.apply((DescribeStorageSystemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String storageSystemArn;
        private DiscoveryServerConfiguration serverConfiguration;
        private String systemType;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String errorMessage;
        private String connectivityStatus;
        private String cloudWatchLogGroupArn;
        private Instant creationTime;
        private String secretsManagerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResponse model) {
            super(model);
            this.storageSystemArn(model.storageSystemArn);
            this.serverConfiguration(model.serverConfiguration);
            this.systemType(model.systemType);
            this.agentArns(model.agentArns);
            this.name(model.name);
            this.errorMessage(model.errorMessage);
            this.connectivityStatus(model.connectivityStatus);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.creationTime(model.creationTime);
            this.secretsManagerArn(model.secretsManagerArn);
        }

        public final String getStorageSystemArn() {
            return this.storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final DiscoveryServerConfiguration.Builder getServerConfiguration() {
            return this.serverConfiguration != null ? this.serverConfiguration.toBuilder() : null;
        }

        public final void setServerConfiguration(DiscoveryServerConfiguration.BuilderImpl serverConfiguration) {
            this.serverConfiguration = serverConfiguration != null ? serverConfiguration.build() : null;
        }

        @Override
        public final Builder serverConfiguration(DiscoveryServerConfiguration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public final String getSystemType() {
            return this.systemType;
        }

        public final void setSystemType(String systemType) {
            this.systemType = systemType;
        }

        @Override
        public final Builder systemType(String systemType) {
            this.systemType = systemType;
            return this;
        }

        @Override
        public final Builder systemType(DiscoverySystemType systemType) {
            this.systemType(systemType == null ? null : systemType.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getConnectivityStatus() {
            return this.connectivityStatus;
        }

        public final void setConnectivityStatus(String connectivityStatus) {
            this.connectivityStatus = connectivityStatus;
        }

        @Override
        public final Builder connectivityStatus(String connectivityStatus) {
            this.connectivityStatus = connectivityStatus;
            return this;
        }

        @Override
        public final Builder connectivityStatus(StorageSystemConnectivityStatus connectivityStatus) {
            this.connectivityStatus(connectivityStatus == null ? null : connectivityStatus.toString());
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSecretsManagerArn() {
            return this.secretsManagerArn;
        }

        public final void setSecretsManagerArn(String secretsManagerArn) {
            this.secretsManagerArn = secretsManagerArn;
        }

        @Override
        public final Builder secretsManagerArn(String secretsManagerArn) {
            this.secretsManagerArn = secretsManagerArn;
            return this;
        }

        @Override
        public DescribeStorageSystemResponse build() {
            return new DescribeStorageSystemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageSystemResponse> {
        public Builder storageSystemArn(String var1);

        public Builder serverConfiguration(DiscoveryServerConfiguration var1);

        default public Builder serverConfiguration(Consumer<DiscoveryServerConfiguration.Builder> serverConfiguration) {
            return this.serverConfiguration((DiscoveryServerConfiguration)((DiscoveryServerConfiguration.Builder)DiscoveryServerConfiguration.builder().applyMutation(serverConfiguration)).build());
        }

        public Builder systemType(String var1);

        public Builder systemType(DiscoverySystemType var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder name(String var1);

        public Builder errorMessage(String var1);

        public Builder connectivityStatus(String var1);

        public Builder connectivityStatus(StorageSystemConnectivityStatus var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder secretsManagerArn(String var1);
    }
}

