/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.Ec2SecurityGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationFsxWindowsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationFsxWindowsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::locationArn)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::locationUri)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::securityGroupArns)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::creationTime)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::user)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribeLocationFsxWindowsResponse.getter(DescribeLocationFsxWindowsResponse::domain)).setter(DescribeLocationFsxWindowsResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, SECURITY_GROUP_ARNS_FIELD, CREATION_TIME_FIELD, USER_FIELD, DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLocationFsxWindowsResponse.memberNameToFieldInitializer();
    private final String locationArn;
    private final String locationUri;
    private final List<String> securityGroupArns;
    private final Instant creationTime;
    private final String user;
    private final String domain;

    private DescribeLocationFsxWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.securityGroupArns = builder.securityGroupArns;
        this.creationTime = builder.creationTime;
        this.user = builder.user;
        this.domain = builder.domain;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String user() {
        return this.user;
    }

    public final String domain() {
        return this.domain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupArns() ? this.securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationFsxWindowsResponse)) {
            return false;
        }
        DescribeLocationFsxWindowsResponse other = (DescribeLocationFsxWindowsResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasSecurityGroupArns() == other.hasSecurityGroupArns() && Objects.equals(this.securityGroupArns(), other.securityGroupArns()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.domain(), other.domain());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationFsxWindowsResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("SecurityGroupArns", this.hasSecurityGroupArns() ? this.securityGroupArns() : null).add("CreationTime", (Object)this.creationTime()).add("User", (Object)this.user()).add("Domain", (Object)this.domain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("SecurityGroupArns", SECURITY_GROUP_ARNS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("User", USER_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationFsxWindowsResponse, T> g) {
        return obj -> g.apply((DescribeLocationFsxWindowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private String user;
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationFsxWindowsResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.securityGroupArns(model.securityGroupArns);
            this.creationTime(model.creationTime);
            this.user(model.user);
            this.domain(model.domain);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (this.securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public DescribeLocationFsxWindowsResponse build() {
            return new DescribeLocationFsxWindowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationFsxWindowsResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder user(String var1);

        public Builder domain(String var1);
    }
}

