/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.model.ListTasksRequest;
import software.amazon.awssdk.services.datasync.model.ListTasksResponse;

public class ListTasksPublisher
implements SdkPublisher<ListTasksResponse> {
    private final DataSyncAsyncClient client;
    private final ListTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTasksPublisher(DataSyncAsyncClient client, ListTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTasksPublisher(DataSyncAsyncClient client, ListTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListTasksPublisher resume(ListTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTasksPublisher(this.client, (ListTasksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTasksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTasksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTasksResponseFetcher
    implements AsyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTasksResponse> nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksPublisher.this.client.listTasks(ListTasksPublisher.this.firstRequest);
            }
            return ListTasksPublisher.this.client.listTasks((ListTasksRequest)((Object)ListTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

