/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.ManifestConfig;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.TaskReportConfig;
import software.amazon.awssdk.services.datasync.model.TaskSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateTaskRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(UpdateTaskRequest.getter(UpdateTaskRequest::taskArn)).setter(UpdateTaskRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(UpdateTaskRequest.getter(UpdateTaskRequest::options)).setter(UpdateTaskRequest.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Excludes").getter(UpdateTaskRequest.getter(UpdateTaskRequest::excludes)).setter(UpdateTaskRequest.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(UpdateTaskRequest.getter(UpdateTaskRequest::schedule)).setter(UpdateTaskRequest.setter(Builder::schedule)).constructor(TaskSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateTaskRequest.getter(UpdateTaskRequest::name)).setter(UpdateTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(UpdateTaskRequest.getter(UpdateTaskRequest::cloudWatchLogGroupArn)).setter(UpdateTaskRequest.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Includes").getter(UpdateTaskRequest.getter(UpdateTaskRequest::includes)).setter(UpdateTaskRequest.setter(Builder::includes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManifestConfig> MANIFEST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestConfig").getter(UpdateTaskRequest.getter(UpdateTaskRequest::manifestConfig)).setter(UpdateTaskRequest.setter(Builder::manifestConfig)).constructor(ManifestConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestConfig").build()}).build();
    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskReportConfig").getter(UpdateTaskRequest.getter(UpdateTaskRequest::taskReportConfig)).setter(UpdateTaskRequest.setter(Builder::taskReportConfig)).constructor(TaskReportConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, SCHEDULE_FIELD, NAME_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INCLUDES_FIELD, MANIFEST_CONFIG_FIELD, TASK_REPORT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TaskArn", TASK_ARN_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("Excludes", EXCLUDES_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
            this.put("Includes", INCLUDES_FIELD);
            this.put("ManifestConfig", MANIFEST_CONFIG_FIELD);
            this.put("TaskReportConfig", TASK_REPORT_CONFIG_FIELD);
        }
    });
    private final String taskArn;
    private final Options options;
    private final List<FilterRule> excludes;
    private final TaskSchedule schedule;
    private final String name;
    private final String cloudWatchLogGroupArn;
    private final List<FilterRule> includes;
    private final ManifestConfig manifestConfig;
    private final TaskReportConfig taskReportConfig;

    private UpdateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.name = builder.name;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.includes = builder.includes;
        this.manifestConfig = builder.manifestConfig;
        this.taskReportConfig = builder.taskReportConfig;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final Options options() {
        return this.options;
    }

    public final boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> excludes() {
        return this.excludes;
    }

    public final TaskSchedule schedule() {
        return this.schedule;
    }

    public final String name() {
        return this.name;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final boolean hasIncludes() {
        return this.includes != null && !(this.includes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> includes() {
        return this.includes;
    }

    public final ManifestConfig manifestConfig() {
        return this.manifestConfig;
    }

    public final TaskReportConfig taskReportConfig() {
        return this.taskReportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludes() ? this.excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludes() ? this.includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskReportConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskRequest)) {
            return false;
        }
        UpdateTaskRequest other = (UpdateTaskRequest)((Object)obj);
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.options(), other.options()) && this.hasExcludes() == other.hasExcludes() && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && this.hasIncludes() == other.hasIncludes() && Objects.equals(this.includes(), other.includes()) && Objects.equals(this.manifestConfig(), other.manifestConfig()) && Objects.equals(this.taskReportConfig(), other.taskReportConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTaskRequest").add("TaskArn", (Object)this.taskArn()).add("Options", (Object)this.options()).add("Excludes", this.hasExcludes() ? this.excludes() : null).add("Schedule", (Object)this.schedule()).add("Name", (Object)this.name()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("Includes", this.hasIncludes() ? this.includes() : null).add("ManifestConfig", (Object)this.manifestConfig()).add("TaskReportConfig", (Object)this.taskReportConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "Includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "ManifestConfig": {
                return Optional.ofNullable(clazz.cast(this.manifestConfig()));
            }
            case "TaskReportConfig": {
                return Optional.ofNullable(clazz.cast(this.taskReportConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskRequest, T> g) {
        return obj -> g.apply((UpdateTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String taskArn;
        private Options options;
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private TaskSchedule schedule;
        private String name;
        private String cloudWatchLogGroupArn;
        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();
        private ManifestConfig manifestConfig;
        private TaskReportConfig taskReportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskRequest model) {
            super(model);
            this.taskArn(model.taskArn);
            this.options(model.options);
            this.excludes(model.excludes);
            this.schedule(model.schedule);
            this.name(model.name);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.includes(model.includes);
            this.manifestConfig(model.manifestConfig);
            this.taskReportConfig(model.taskReportConfig);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TaskSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule ... includes) {
            this.includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder> ... includes) {
            this.includes(Stream.of(includes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManifestConfig.Builder getManifestConfig() {
            return this.manifestConfig != null ? this.manifestConfig.toBuilder() : null;
        }

        public final void setManifestConfig(ManifestConfig.BuilderImpl manifestConfig) {
            this.manifestConfig = manifestConfig != null ? manifestConfig.build() : null;
        }

        @Override
        public final Builder manifestConfig(ManifestConfig manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return this.taskReportConfig != null ? this.taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskRequest build() {
            return new UpdateTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskRequest> {
        public Builder taskArn(String var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder schedule(TaskSchedule var1);

        default public Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return this.schedule((TaskSchedule)((TaskSchedule.Builder)TaskSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder name(String var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder includes(Collection<FilterRule> var1);

        public Builder includes(FilterRule ... var1);

        public Builder includes(Consumer<FilterRule.Builder> ... var1);

        public Builder manifestConfig(ManifestConfig var1);

        default public Builder manifestConfig(Consumer<ManifestConfig.Builder> manifestConfig) {
            return this.manifestConfig((ManifestConfig)((ManifestConfig.Builder)ManifestConfig.builder().applyMutation(manifestConfig)).build());
        }

        public Builder taskReportConfig(TaskReportConfig var1);

        default public Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return this.taskReportConfig((TaskReportConfig)((TaskReportConfig.Builder)TaskReportConfig.builder().applyMutation(taskReportConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

