/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.PLSecurityGroupArnListCopier;
import software.amazon.awssdk.services.datasync.model.PLSubnetArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateLinkConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateLinkConfig> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(PrivateLinkConfig.getter(PrivateLinkConfig::vpcEndpointId)).setter(PrivateLinkConfig.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> PRIVATE_LINK_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateLinkEndpoint").getter(PrivateLinkConfig.getter(PrivateLinkConfig::privateLinkEndpoint)).setter(PrivateLinkConfig.setter(Builder::privateLinkEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkEndpoint").build()}).build();
    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetArns").getter(PrivateLinkConfig.getter(PrivateLinkConfig::subnetArns)).setter(PrivateLinkConfig.setter(Builder::subnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(PrivateLinkConfig.getter(PrivateLinkConfig::securityGroupArns)).setter(PrivateLinkConfig.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, PRIVATE_LINK_ENDPOINT_FIELD, SUBNET_ARNS_FIELD, SECURITY_GROUP_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
            this.put("PrivateLinkEndpoint", PRIVATE_LINK_ENDPOINT_FIELD);
            this.put("SubnetArns", SUBNET_ARNS_FIELD);
            this.put("SecurityGroupArns", SECURITY_GROUP_ARNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointId;
    private final String privateLinkEndpoint;
    private final List<String> subnetArns;
    private final List<String> securityGroupArns;

    private PrivateLinkConfig(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.privateLinkEndpoint = builder.privateLinkEndpoint;
        this.subnetArns = builder.subnetArns;
        this.securityGroupArns = builder.securityGroupArns;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String privateLinkEndpoint() {
        return this.privateLinkEndpoint;
    }

    public final boolean hasSubnetArns() {
        return this.subnetArns != null && !(this.subnetArns instanceof SdkAutoConstructList);
    }

    public final List<String> subnetArns() {
        return this.subnetArns;
    }

    public final boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLinkEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetArns() ? this.subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupArns() ? this.securityGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateLinkConfig)) {
            return false;
        }
        PrivateLinkConfig other = (PrivateLinkConfig)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.privateLinkEndpoint(), other.privateLinkEndpoint()) && this.hasSubnetArns() == other.hasSubnetArns() && Objects.equals(this.subnetArns(), other.subnetArns()) && this.hasSecurityGroupArns() == other.hasSecurityGroupArns() && Objects.equals(this.securityGroupArns(), other.securityGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateLinkConfig").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("PrivateLinkEndpoint", (Object)this.privateLinkEndpoint()).add("SubnetArns", this.hasSubnetArns() ? this.subnetArns() : null).add("SecurityGroupArns", this.hasSecurityGroupArns() ? this.securityGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "PrivateLinkEndpoint": {
                return Optional.ofNullable(clazz.cast(this.privateLinkEndpoint()));
            }
            case "SubnetArns": {
                return Optional.ofNullable(clazz.cast(this.subnetArns()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrivateLinkConfig, T> g) {
        return obj -> g.apply((PrivateLinkConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String privateLinkEndpoint;
        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateLinkConfig model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.privateLinkEndpoint(model.privateLinkEndpoint);
            this.subnetArns(model.subnetArns);
            this.securityGroupArns(model.securityGroupArns);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getPrivateLinkEndpoint() {
            return this.privateLinkEndpoint;
        }

        public final void setPrivateLinkEndpoint(String privateLinkEndpoint) {
            this.privateLinkEndpoint = privateLinkEndpoint;
        }

        @Override
        public final Builder privateLinkEndpoint(String privateLinkEndpoint) {
            this.privateLinkEndpoint = privateLinkEndpoint;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (this.subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String ... subnetArns) {
            this.subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (this.securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public PrivateLinkConfig build() {
            return new PrivateLinkConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateLinkConfig> {
        public Builder vpcEndpointId(String var1);

        public Builder privateLinkEndpoint(String var1);

        public Builder subnetArns(Collection<String> var1);

        public Builder subnetArns(String ... var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);
    }
}

