/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDiscoveryJobResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeDiscoveryJobResponse> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSystemArn").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::storageSystemArn)).setter(DescribeDiscoveryJobResponse.setter(Builder::storageSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()}).build();
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryJobArn").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::discoveryJobArn)).setter(DescribeDiscoveryJobResponse.setter(Builder::discoveryJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()}).build();
    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CollectionDurationMinutes").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::collectionDurationMinutes)).setter(DescribeDiscoveryJobResponse.setter(Builder::collectionDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::statusAsString)).setter(DescribeDiscoveryJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobStartTime").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::jobStartTime)).setter(DescribeDiscoveryJobResponse.setter(Builder::jobStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()}).build();
    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobEndTime").getter(DescribeDiscoveryJobResponse.getter(DescribeDiscoveryJobResponse::jobEndTime)).setter(DescribeDiscoveryJobResponse.setter(Builder::jobEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD, DISCOVERY_JOB_ARN_FIELD, COLLECTION_DURATION_MINUTES_FIELD, STATUS_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD));
    private final String storageSystemArn;
    private final String discoveryJobArn;
    private final Integer collectionDurationMinutes;
    private final String status;
    private final Instant jobStartTime;
    private final Instant jobEndTime;

    private DescribeDiscoveryJobResponse(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.discoveryJobArn = builder.discoveryJobArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
        this.status = builder.status;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
    }

    public final String storageSystemArn() {
        return this.storageSystemArn;
    }

    public final String discoveryJobArn() {
        return this.discoveryJobArn;
    }

    public final Integer collectionDurationMinutes() {
        return this.collectionDurationMinutes;
    }

    public final DiscoveryJobStatus status() {
        return DiscoveryJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant jobStartTime() {
        return this.jobStartTime;
    }

    public final Instant jobEndTime() {
        return this.jobEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDiscoveryJobResponse)) {
            return false;
        }
        DescribeDiscoveryJobResponse other = (DescribeDiscoveryJobResponse)((Object)obj);
        return Objects.equals(this.storageSystemArn(), other.storageSystemArn()) && Objects.equals(this.discoveryJobArn(), other.discoveryJobArn()) && Objects.equals(this.collectionDurationMinutes(), other.collectionDurationMinutes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.jobStartTime(), other.jobStartTime()) && Objects.equals(this.jobEndTime(), other.jobEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDiscoveryJobResponse").add("StorageSystemArn", (Object)this.storageSystemArn()).add("DiscoveryJobArn", (Object)this.discoveryJobArn()).add("CollectionDurationMinutes", (Object)this.collectionDurationMinutes()).add("Status", (Object)this.statusAsString()).add("JobStartTime", (Object)this.jobStartTime()).add("JobEndTime", (Object)this.jobEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageSystemArn": {
                return Optional.ofNullable(clazz.cast(this.storageSystemArn()));
            }
            case "DiscoveryJobArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryJobArn()));
            }
            case "CollectionDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.collectionDurationMinutes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "JobStartTime": {
                return Optional.ofNullable(clazz.cast(this.jobStartTime()));
            }
            case "JobEndTime": {
                return Optional.ofNullable(clazz.cast(this.jobEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDiscoveryJobResponse, T> g) {
        return obj -> g.apply((DescribeDiscoveryJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String storageSystemArn;
        private String discoveryJobArn;
        private Integer collectionDurationMinutes;
        private String status;
        private Instant jobStartTime;
        private Instant jobEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDiscoveryJobResponse model) {
            super(model);
            this.storageSystemArn(model.storageSystemArn);
            this.discoveryJobArn(model.discoveryJobArn);
            this.collectionDurationMinutes(model.collectionDurationMinutes);
            this.status(model.status);
            this.jobStartTime(model.jobStartTime);
            this.jobEndTime(model.jobEndTime);
        }

        public final String getStorageSystemArn() {
            return this.storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final String getDiscoveryJobArn() {
            return this.discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return this.collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DiscoveryJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getJobStartTime() {
            return this.jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return this.jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        @Override
        public DescribeDiscoveryJobResponse build() {
            return new DescribeDiscoveryJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDiscoveryJobResponse> {
        public Builder storageSystemArn(String var1);

        public Builder discoveryJobArn(String var1);

        public Builder collectionDurationMinutes(Integer var1);

        public Builder status(String var1);

        public Builder status(DiscoveryJobStatus var1);

        public Builder jobStartTime(Instant var1);

        public Builder jobEndTime(Instant var1);
    }
}

