/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryResourceType {
    SVM("SVM"),
    VOLUME("VOLUME"),
    CLUSTER("CLUSTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryResourceType> VALUE_MAP;
    private final String value;

    private DiscoveryResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryResourceType> knownValues() {
        EnumSet<DiscoveryResourceType> knownValues = EnumSet.allOf(DiscoveryResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryResourceType.class, DiscoveryResourceType::toString);
    }
}

