/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse;

public class ListDiscoveryJobsIterable
implements SdkIterable<ListDiscoveryJobsResponse> {
    private final DataSyncClient client;
    private final ListDiscoveryJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDiscoveryJobsIterable(DataSyncClient client, ListDiscoveryJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDiscoveryJobsResponseFetcher();
    }

    public Iterator<ListDiscoveryJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DiscoveryJobListEntry> discoveryJobs() {
        Function<ListDiscoveryJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoveryJobs() != null) {
                return response.discoveryJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDiscoveryJobsResponseFetcher
    implements SyncPageFetcher<ListDiscoveryJobsResponse> {
        private ListDiscoveryJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveryJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDiscoveryJobsResponse nextPage(ListDiscoveryJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveryJobsIterable.this.client.listDiscoveryJobs(ListDiscoveryJobsIterable.this.firstRequest);
            }
            return ListDiscoveryJobsIterable.this.client.listDiscoveryJobs((ListDiscoveryJobsRequest)((Object)ListDiscoveryJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

