/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.MaxP95Performance;
import software.amazon.awssdk.services.datasync.model.Recommendation;
import software.amazon.awssdk.services.datasync.model.RecommendationStatus;
import software.amazon.awssdk.services.datasync.model.RecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetAppONTAPCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetAppONTAPCluster> {
    private static final SdkField<Long> CIFS_SHARE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CifsShareCount").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::cifsShareCount)).setter(NetAppONTAPCluster.setter(Builder::cifsShareCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CifsShareCount").build()}).build();
    private static final SdkField<Long> NFS_EXPORTED_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NfsExportedVolumes").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::nfsExportedVolumes)).setter(NetAppONTAPCluster.setter(Builder::nfsExportedVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExportedVolumes").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::resourceId)).setter(NetAppONTAPCluster.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::clusterName)).setter(NetAppONTAPCluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<MaxP95Performance> MAX_P95_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxP95Performance").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::maxP95Performance)).setter(NetAppONTAPCluster.setter(Builder::maxP95Performance)).constructor(MaxP95Performance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxP95Performance").build()}).build();
    private static final SdkField<Long> CLUSTER_BLOCK_STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ClusterBlockStorageSize").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::clusterBlockStorageSize)).setter(NetAppONTAPCluster.setter(Builder::clusterBlockStorageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterBlockStorageSize").build()}).build();
    private static final SdkField<Long> CLUSTER_BLOCK_STORAGE_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ClusterBlockStorageUsed").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::clusterBlockStorageUsed)).setter(NetAppONTAPCluster.setter(Builder::clusterBlockStorageUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterBlockStorageUsed").build()}).build();
    private static final SdkField<Long> CLUSTER_BLOCK_STORAGE_LOGICAL_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ClusterBlockStorageLogicalUsed").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::clusterBlockStorageLogicalUsed)).setter(NetAppONTAPCluster.setter(Builder::clusterBlockStorageLogicalUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterBlockStorageLogicalUsed").build()}).build();
    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommendations").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::recommendations)).setter(NetAppONTAPCluster.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationStatus").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::recommendationStatusAsString)).setter(NetAppONTAPCluster.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationStatus").build()}).build();
    private static final SdkField<Long> LUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LunCount").getter(NetAppONTAPCluster.getter(NetAppONTAPCluster::lunCount)).setter(NetAppONTAPCluster.setter(Builder::lunCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LunCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIFS_SHARE_COUNT_FIELD, NFS_EXPORTED_VOLUMES_FIELD, RESOURCE_ID_FIELD, CLUSTER_NAME_FIELD, MAX_P95_PERFORMANCE_FIELD, CLUSTER_BLOCK_STORAGE_SIZE_FIELD, CLUSTER_BLOCK_STORAGE_USED_FIELD, CLUSTER_BLOCK_STORAGE_LOGICAL_USED_FIELD, RECOMMENDATIONS_FIELD, RECOMMENDATION_STATUS_FIELD, LUN_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long cifsShareCount;
    private final Long nfsExportedVolumes;
    private final String resourceId;
    private final String clusterName;
    private final MaxP95Performance maxP95Performance;
    private final Long clusterBlockStorageSize;
    private final Long clusterBlockStorageUsed;
    private final Long clusterBlockStorageLogicalUsed;
    private final List<Recommendation> recommendations;
    private final String recommendationStatus;
    private final Long lunCount;

    private NetAppONTAPCluster(BuilderImpl builder) {
        this.cifsShareCount = builder.cifsShareCount;
        this.nfsExportedVolumes = builder.nfsExportedVolumes;
        this.resourceId = builder.resourceId;
        this.clusterName = builder.clusterName;
        this.maxP95Performance = builder.maxP95Performance;
        this.clusterBlockStorageSize = builder.clusterBlockStorageSize;
        this.clusterBlockStorageUsed = builder.clusterBlockStorageUsed;
        this.clusterBlockStorageLogicalUsed = builder.clusterBlockStorageLogicalUsed;
        this.recommendations = builder.recommendations;
        this.recommendationStatus = builder.recommendationStatus;
        this.lunCount = builder.lunCount;
    }

    public final Long cifsShareCount() {
        return this.cifsShareCount;
    }

    public final Long nfsExportedVolumes() {
        return this.nfsExportedVolumes;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final MaxP95Performance maxP95Performance() {
        return this.maxP95Performance;
    }

    public final Long clusterBlockStorageSize() {
        return this.clusterBlockStorageSize;
    }

    public final Long clusterBlockStorageUsed() {
        return this.clusterBlockStorageUsed;
    }

    public final Long clusterBlockStorageLogicalUsed() {
        return this.clusterBlockStorageLogicalUsed;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<Recommendation> recommendations() {
        return this.recommendations;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final Long lunCount() {
        return this.lunCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cifsShareCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsExportedVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxP95Performance());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterBlockStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterBlockStorageUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterBlockStorageLogicalUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lunCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetAppONTAPCluster)) {
            return false;
        }
        NetAppONTAPCluster other = (NetAppONTAPCluster)obj;
        return Objects.equals(this.cifsShareCount(), other.cifsShareCount()) && Objects.equals(this.nfsExportedVolumes(), other.nfsExportedVolumes()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.maxP95Performance(), other.maxP95Performance()) && Objects.equals(this.clusterBlockStorageSize(), other.clusterBlockStorageSize()) && Objects.equals(this.clusterBlockStorageUsed(), other.clusterBlockStorageUsed()) && Objects.equals(this.clusterBlockStorageLogicalUsed(), other.clusterBlockStorageLogicalUsed()) && this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && Objects.equals(this.lunCount(), other.lunCount());
    }

    public final String toString() {
        return ToString.builder((String)"NetAppONTAPCluster").add("CifsShareCount", (Object)this.cifsShareCount()).add("NfsExportedVolumes", (Object)this.nfsExportedVolumes()).add("ResourceId", (Object)this.resourceId()).add("ClusterName", (Object)this.clusterName()).add("MaxP95Performance", (Object)this.maxP95Performance()).add("ClusterBlockStorageSize", (Object)this.clusterBlockStorageSize()).add("ClusterBlockStorageUsed", (Object)this.clusterBlockStorageUsed()).add("ClusterBlockStorageLogicalUsed", (Object)this.clusterBlockStorageLogicalUsed()).add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("LunCount", (Object)this.lunCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CifsShareCount": {
                return Optional.ofNullable(clazz.cast(this.cifsShareCount()));
            }
            case "NfsExportedVolumes": {
                return Optional.ofNullable(clazz.cast(this.nfsExportedVolumes()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "MaxP95Performance": {
                return Optional.ofNullable(clazz.cast(this.maxP95Performance()));
            }
            case "ClusterBlockStorageSize": {
                return Optional.ofNullable(clazz.cast(this.clusterBlockStorageSize()));
            }
            case "ClusterBlockStorageUsed": {
                return Optional.ofNullable(clazz.cast(this.clusterBlockStorageUsed()));
            }
            case "ClusterBlockStorageLogicalUsed": {
                return Optional.ofNullable(clazz.cast(this.clusterBlockStorageLogicalUsed()));
            }
            case "Recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "RecommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "LunCount": {
                return Optional.ofNullable(clazz.cast(this.lunCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetAppONTAPCluster, T> g) {
        return obj -> g.apply((NetAppONTAPCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long cifsShareCount;
        private Long nfsExportedVolumes;
        private String resourceId;
        private String clusterName;
        private MaxP95Performance maxP95Performance;
        private Long clusterBlockStorageSize;
        private Long clusterBlockStorageUsed;
        private Long clusterBlockStorageLogicalUsed;
        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();
        private String recommendationStatus;
        private Long lunCount;

        private BuilderImpl() {
        }

        private BuilderImpl(NetAppONTAPCluster model) {
            this.cifsShareCount(model.cifsShareCount);
            this.nfsExportedVolumes(model.nfsExportedVolumes);
            this.resourceId(model.resourceId);
            this.clusterName(model.clusterName);
            this.maxP95Performance(model.maxP95Performance);
            this.clusterBlockStorageSize(model.clusterBlockStorageSize);
            this.clusterBlockStorageUsed(model.clusterBlockStorageUsed);
            this.clusterBlockStorageLogicalUsed(model.clusterBlockStorageLogicalUsed);
            this.recommendations(model.recommendations);
            this.recommendationStatus(model.recommendationStatus);
            this.lunCount(model.lunCount);
        }

        public final Long getCifsShareCount() {
            return this.cifsShareCount;
        }

        public final void setCifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
        }

        @Override
        public final Builder cifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
            return this;
        }

        public final Long getNfsExportedVolumes() {
            return this.nfsExportedVolumes;
        }

        public final void setNfsExportedVolumes(Long nfsExportedVolumes) {
            this.nfsExportedVolumes = nfsExportedVolumes;
        }

        @Override
        public final Builder nfsExportedVolumes(Long nfsExportedVolumes) {
            this.nfsExportedVolumes = nfsExportedVolumes;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final MaxP95Performance.Builder getMaxP95Performance() {
            return this.maxP95Performance != null ? this.maxP95Performance.toBuilder() : null;
        }

        public final void setMaxP95Performance(MaxP95Performance.BuilderImpl maxP95Performance) {
            this.maxP95Performance = maxP95Performance != null ? maxP95Performance.build() : null;
        }

        @Override
        public final Builder maxP95Performance(MaxP95Performance maxP95Performance) {
            this.maxP95Performance = maxP95Performance;
            return this;
        }

        public final Long getClusterBlockStorageSize() {
            return this.clusterBlockStorageSize;
        }

        public final void setClusterBlockStorageSize(Long clusterBlockStorageSize) {
            this.clusterBlockStorageSize = clusterBlockStorageSize;
        }

        @Override
        public final Builder clusterBlockStorageSize(Long clusterBlockStorageSize) {
            this.clusterBlockStorageSize = clusterBlockStorageSize;
            return this;
        }

        public final Long getClusterBlockStorageUsed() {
            return this.clusterBlockStorageUsed;
        }

        public final void setClusterBlockStorageUsed(Long clusterBlockStorageUsed) {
            this.clusterBlockStorageUsed = clusterBlockStorageUsed;
        }

        @Override
        public final Builder clusterBlockStorageUsed(Long clusterBlockStorageUsed) {
            this.clusterBlockStorageUsed = clusterBlockStorageUsed;
            return this;
        }

        public final Long getClusterBlockStorageLogicalUsed() {
            return this.clusterBlockStorageLogicalUsed;
        }

        public final void setClusterBlockStorageLogicalUsed(Long clusterBlockStorageLogicalUsed) {
            this.clusterBlockStorageLogicalUsed = clusterBlockStorageLogicalUsed;
        }

        @Override
        public final Builder clusterBlockStorageLogicalUsed(Long clusterBlockStorageLogicalUsed) {
            this.clusterBlockStorageLogicalUsed = clusterBlockStorageLogicalUsed;
            return this;
        }

        public final List<Recommendation.Builder> getRecommendations() {
            List<Recommendation.Builder> result = RecommendationsCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final Long getLunCount() {
            return this.lunCount;
        }

        public final void setLunCount(Long lunCount) {
            this.lunCount = lunCount;
        }

        @Override
        public final Builder lunCount(Long lunCount) {
            this.lunCount = lunCount;
            return this;
        }

        public NetAppONTAPCluster build() {
            return new NetAppONTAPCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetAppONTAPCluster> {
        public Builder cifsShareCount(Long var1);

        public Builder nfsExportedVolumes(Long var1);

        public Builder resourceId(String var1);

        public Builder clusterName(String var1);

        public Builder maxP95Performance(MaxP95Performance var1);

        default public Builder maxP95Performance(Consumer<MaxP95Performance.Builder> maxP95Performance) {
            return this.maxP95Performance((MaxP95Performance)((MaxP95Performance.Builder)MaxP95Performance.builder().applyMutation(maxP95Performance)).build());
        }

        public Builder clusterBlockStorageSize(Long var1);

        public Builder clusterBlockStorageUsed(Long var1);

        public Builder clusterBlockStorageLogicalUsed(Long var1);

        public Builder recommendations(Collection<Recommendation> var1);

        public Builder recommendations(Recommendation ... var1);

        public Builder recommendations(Consumer<Recommendation.Builder> ... var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder lunCount(Long var1);
    }
}

