/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.AgentListEntry;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;

public class ListAgentsIterable
implements SdkIterable<ListAgentsResponse> {
    private final DataSyncClient client;
    private final ListAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentsIterable(DataSyncClient client, ListAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAgentsResponseFetcher();
    }

    public Iterator<ListAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentListEntry> agents() {
        Function<ListAgentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agents() != null) {
                return response.agents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentsResponseFetcher
    implements SyncPageFetcher<ListAgentsResponse> {
        private ListAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentsResponse nextPage(ListAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentsIterable.this.client.listAgents(ListAgentsIterable.this.firstRequest);
            }
            return ListAgentsIterable.this.client.listAgents((ListAgentsRequest)((Object)ListAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

