/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentListCopier;
import software.amazon.awssdk.services.datasync.model.AgentListEntry;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, ListAgentsResponse> {
    private static final SdkField<List<AgentListEntry>> AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAgentsResponse.getter(ListAgentsResponse::agents)).setter(ListAgentsResponse.setter(Builder::agents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAgentsResponse.getter(ListAgentsResponse::nextToken)).setter(ListAgentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AgentListEntry> agents;
    private final String nextToken;

    private ListAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agents = builder.agents;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAgents() {
        return this.agents != null && !(this.agents instanceof SdkAutoConstructList);
    }

    public List<AgentListEntry> agents() {
        return this.agents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentsResponse)) {
            return false;
        }
        ListAgentsResponse other = (ListAgentsResponse)((Object)obj);
        return Objects.equals(this.agents(), other.agents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAgentsResponse").add("Agents", this.agents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Agents": {
                return Optional.ofNullable(clazz.cast(this.agents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentsResponse, T> g) {
        return obj -> g.apply((ListAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private List<AgentListEntry> agents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentsResponse model) {
            super(model);
            this.agents(model.agents);
            this.nextToken(model.nextToken);
        }

        public final Collection<AgentListEntry.Builder> getAgents() {
            return this.agents != null ? (Collection)this.agents.stream().map(AgentListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agents(Collection<AgentListEntry> agents) {
            this.agents = AgentListCopier.copy(agents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(AgentListEntry ... agents) {
            this.agents(Arrays.asList(agents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(Consumer<AgentListEntry.Builder> ... agents) {
            this.agents(Stream.of(agents).map(c -> (AgentListEntry)((AgentListEntry.Builder)AgentListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgents(Collection<AgentListEntry.BuilderImpl> agents) {
            this.agents = AgentListCopier.copyFromBuilder(agents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAgentsResponse build() {
            return new ListAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentsResponse> {
        public Builder agents(Collection<AgentListEntry> var1);

        public Builder agents(AgentListEntry ... var1);

        public Builder agents(Consumer<AgentListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

