/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.Selector;
import software.amazon.awssdk.services.datapipeline.model.SelectorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Query
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Query> {
    private static final SdkField<List<Selector>> SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectors").getter(Query.getter(Query::selectors)).setter(Query.setter(Builder::selectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Selector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("selectors", SELECTORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Selector> selectors;

    private Query(BuilderImpl builder) {
        this.selectors = builder.selectors;
    }

    public final boolean hasSelectors() {
        return this.selectors != null && !(this.selectors instanceof SdkAutoConstructList);
    }

    public final List<Selector> selectors() {
        return this.selectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectors() ? this.selectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return this.hasSelectors() == other.hasSelectors() && Objects.equals(this.selectors(), other.selectors());
    }

    public final String toString() {
        return ToString.builder((String)"Query").add("Selectors", this.hasSelectors() ? this.selectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selectors": {
                return Optional.ofNullable(clazz.cast(this.selectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Selector> selectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            this.selectors(model.selectors);
        }

        public final List<Selector.Builder> getSelectors() {
            List<Selector.Builder> result = SelectorListCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<Selector.BuilderImpl> selectors) {
            this.selectors = SelectorListCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Selector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<Selector.Builder> ... selectors) {
            this.selectors(Stream.of(selectors).map(c -> (Selector)((Selector.Builder)Selector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Query build() {
            return new Query(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Query> {
        public Builder selectors(Collection<Selector> var1);

        public Builder selectors(Selector ... var1);

        public Builder selectors(Consumer<Selector.Builder> ... var1);
    }
}

