/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;
import software.amazon.awssdk.services.datapipeline.model._pipelineListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelinesResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, ListPipelinesResponse> {
    private static final SdkField<List<PipelineIdName>> PIPELINE_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineIdList").getter(ListPipelinesResponse.getter(ListPipelinesResponse::pipelineIdList)).setter(ListPipelinesResponse.setter(Builder::pipelineIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineIdName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("marker").getter(ListPipelinesResponse.getter(ListPipelinesResponse::marker)).setter(ListPipelinesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()}).build();
    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasMoreResults").getter(ListPipelinesResponse.getter(ListPipelinesResponse::hasMoreResults)).setter(ListPipelinesResponse.setter(Builder::hasMoreResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_LIST_FIELD, MARKER_FIELD, HAS_MORE_RESULTS_FIELD));
    private final List<PipelineIdName> pipelineIdList;
    private final String marker;
    private final Boolean hasMoreResults;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineIdList = builder.pipelineIdList;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public final boolean hasPipelineIdList() {
        return this.pipelineIdList != null && !(this.pipelineIdList instanceof SdkAutoConstructList);
    }

    public final List<PipelineIdName> pipelineIdList() {
        return this.pipelineIdList;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineIdList() ? this.pipelineIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse)((Object)obj);
        return this.hasPipelineIdList() == other.hasPipelineIdList() && Objects.equals(this.pipelineIdList(), other.pipelineIdList()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hasMoreResults(), other.hasMoreResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelinesResponse").add("PipelineIdList", this.hasPipelineIdList() ? this.pipelineIdList() : null).add("Marker", (Object)this.marker()).add("HasMoreResults", (Object)this.hasMoreResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineIdList": {
                return Optional.ofNullable(clazz.cast(this.pipelineIdList()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.ofNullable(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineIdName> pipelineIdList = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            this.pipelineIdList(model.pipelineIdList);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final List<PipelineIdName.Builder> getPipelineIdList() {
            List<PipelineIdName.Builder> result = _pipelineListCopier.copyToBuilder(this.pipelineIdList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pipelineIdList(Collection<PipelineIdName> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copy(pipelineIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(PipelineIdName ... pipelineIdList) {
            this.pipelineIdList(Arrays.asList(pipelineIdList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(Consumer<PipelineIdName.Builder> ... pipelineIdList) {
            this.pipelineIdList(Stream.of(pipelineIdList).map(c -> (PipelineIdName)((PipelineIdName.Builder)PipelineIdName.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineIdList(Collection<PipelineIdName.BuilderImpl> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copyFromBuilder(pipelineIdList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelinesResponse> {
        public Builder pipelineIdList(Collection<PipelineIdName> var1);

        public Builder pipelineIdList(PipelineIdName ... var1);

        public Builder pipelineIdList(Consumer<PipelineIdName.Builder> ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

