/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a pipeline object. This can be a logical, physical, or physical attempt pipeline object.
 * The complete set of components of a pipeline defines the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineObject implements SdkPojo, Serializable, ToCopyableBuilder<PipelineObject.Builder, PipelineObject> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PipelineObject::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PipelineObject::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Field>> FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(PipelineObject::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final List<Field> fields;

    private PipelineObject(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * The ID of the object.
     * </p>
     * 
     * @return The ID of the object.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the object.
     * </p>
     * 
     * @return The name of the object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that define the properties of the object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Key-value pairs that define the properties of the object.
     */
    public final List<Field> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineObject)) {
            return false;
        }
        PipelineObject other = (PipelineObject) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineObject").add("Id", id()).add("Name", name())
                .add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineObject, T> g) {
        return obj -> g.apply((PipelineObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineObject> {
        /**
         * <p>
         * The ID of the object.
         * </p>
         * 
         * @param id
         *        The ID of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the object.
         * </p>
         * 
         * @param name
         *        The name of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Key-value pairs that define the properties of the object.
         * </p>
         * 
         * @param fields
         *        Key-value pairs that define the properties of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<Field> fields);

        /**
         * <p>
         * Key-value pairs that define the properties of the object.
         * </p>
         * 
         * @param fields
         *        Key-value pairs that define the properties of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Field... fields);

        /**
         * <p>
         * Key-value pairs that define the properties of the object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #fields(List<Field>)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(List<Field>)
         */
        Builder fields(Consumer<Field.Builder>... fields);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private List<Field> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineObject model) {
            id(model.id);
            name(model.name);
            fields(model.fields);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Field.Builder> getFields() {
            if (fields instanceof SdkAutoConstructList) {
                return null;
            }
            return fields != null ? fields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<Field.Builder>... fields) {
            fields(Stream.of(fields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFields(Collection<Field.BuilderImpl> fields) {
            this.fields = _fieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public PipelineObject build() {
            return new PipelineObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
