/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.model.ParameterObjectListCopier;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineDefinitionResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, GetPipelineDefinitionResponse> {
    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineObjects").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::pipelineObjects)).setter(GetPipelineDefinitionResponse.setter(Builder::pipelineObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterObject>> PARAMETER_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterObjects").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::parameterObjects)).setter(GetPipelineDefinitionResponse.setter(Builder::parameterObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterValues").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::parameterValues)).setter(GetPipelineDefinitionResponse.setter(Builder::parameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_OBJECTS_FIELD, PARAMETER_OBJECTS_FIELD, PARAMETER_VALUES_FIELD));
    private final List<PipelineObject> pipelineObjects;
    private final List<ParameterObject> parameterObjects;
    private final List<ParameterValue> parameterValues;

    private GetPipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    public boolean hasPipelineObjects() {
        return this.pipelineObjects != null && !(this.pipelineObjects instanceof SdkAutoConstructList);
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public boolean hasParameterObjects() {
        return this.parameterObjects != null && !(this.parameterObjects instanceof SdkAutoConstructList);
    }

    public List<ParameterObject> parameterObjects() {
        return this.parameterObjects;
    }

    public boolean hasParameterValues() {
        return this.parameterValues != null && !(this.parameterValues instanceof SdkAutoConstructList);
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineObjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterObjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionResponse)) {
            return false;
        }
        GetPipelineDefinitionResponse other = (GetPipelineDefinitionResponse)((Object)obj);
        return Objects.equals(this.pipelineObjects(), other.pipelineObjects()) && Objects.equals(this.parameterObjects(), other.parameterObjects()) && Objects.equals(this.parameterValues(), other.parameterValues());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineDefinitionResponse").add("PipelineObjects", this.pipelineObjects()).add("ParameterObjects", this.parameterObjects()).add("ParameterValues", this.parameterValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineObjects": {
                return Optional.ofNullable(clazz.cast(this.pipelineObjects()));
            }
            case "parameterObjects": {
                return Optional.ofNullable(clazz.cast(this.parameterObjects()));
            }
            case "parameterValues": {
                return Optional.ofNullable(clazz.cast(this.parameterValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineDefinitionResponse, T> g) {
        return obj -> g.apply((GetPipelineDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterObject> parameterObjects = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineDefinitionResponse model) {
            super(model);
            this.pipelineObjects(model.pipelineObjects);
            this.parameterObjects(model.parameterObjects);
            this.parameterValues(model.parameterValues);
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return this.pipelineObjects != null ? (Collection)this.pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder> ... pipelineObjects) {
            this.pipelineObjects(Stream.of(pipelineObjects).map(c -> (PipelineObject)((PipelineObject.Builder)PipelineObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final Collection<ParameterObject.Builder> getParameterObjects() {
            return this.parameterObjects != null ? (Collection)this.parameterObjects.stream().map(ParameterObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject ... parameterObjects) {
            this.parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(Consumer<ParameterObject.Builder> ... parameterObjects) {
            this.parameterObjects(Stream.of(parameterObjects).map(c -> (ParameterObject)((ParameterObject.Builder)ParameterObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject.BuilderImpl> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copyFromBuilder(parameterObjects);
        }

        public final Collection<ParameterValue.Builder> getParameterValues() {
            return this.parameterValues != null ? (Collection)this.parameterValues.stream().map(ParameterValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder> ... parameterValues) {
            this.parameterValues(Stream.of(parameterValues).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public GetPipelineDefinitionResponse build() {
            return new GetPipelineDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineDefinitionResponse> {
        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder pipelineObjects(Consumer<PipelineObject.Builder> ... var1);

        public Builder parameterObjects(Collection<ParameterObject> var1);

        public Builder parameterObjects(ParameterObject ... var1);

        public Builder parameterObjects(Consumer<ParameterObject.Builder> ... var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder parameterValues(Consumer<ParameterValue.Builder> ... var1);
    }
}

