/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains pipeline metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineDescription.Builder, PipelineDescription> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineDescription::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Field>> FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .getter(getter(PipelineDescription::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PipelineDescription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, NAME_FIELD,
            FIELDS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineId;

    private final String name;

    private final List<Field> fields;

    private final String description;

    private final List<Tag> tags;

    private PipelineDescription(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.name = builder.name;
        this.fields = builder.fields;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form
     * <code>df-297EG78HU43EEXAMPLE</code>.
     * </p>
     * 
     * @return The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form
     *         <code>df-297EG78HU43EEXAMPLE</code>.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and
     *         @pipelineState.
     */
    public List<Field> fields() {
        return fields;
    }

    /**
     * <p>
     * Description of the pipeline.
     * </p>
     * 
     * @return Description of the pipeline.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information, see
     * <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
     * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling
     *         User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDescription)) {
            return false;
        }
        PipelineDescription other = (PipelineDescription) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(name(), other.name())
                && Objects.equals(fields(), other.fields()) && Objects.equals(description(), other.description())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PipelineDescription").add("PipelineId", pipelineId()).add("Name", name())
                .add("Fields", fields()).add("Description", description()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDescription, T> g) {
        return obj -> g.apply((PipelineDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineDescription> {
        /**
         * <p>
         * The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form
         * <code>df-297EG78HU43EEXAMPLE</code>.
         * </p>
         * 
         * @param pipelineId
         *        The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form
         *        <code>df-297EG78HU43EEXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param name
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
         * </p>
         * 
         * @param fields
         *        A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and
         *        @pipelineState.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<Field> fields);

        /**
         * <p>
         * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
         * </p>
         * 
         * @param fields
         *        A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and
         *        @pipelineState.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Field... fields);

        /**
         * <p>
         * A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #fields(List<Field>)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(List<Field>)
         */
        Builder fields(Consumer<Field.Builder>... fields);

        /**
         * <p>
         * Description of the pipeline.
         * </p>
         * 
         * @param description
         *        Description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information,
         * see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html"
         *        >Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information,
         * see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html"
         *        >Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associated with a pipeline. Tags let you control access to pipelines. For more information,
         * see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User
         * Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineId;

        private String name;

        private List<Field> fields = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDescription model) {
            pipelineId(model.pipelineId);
            name(model.name);
            fields(model.fields);
            description(model.description);
            tags(model.tags);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Field.Builder> getFields() {
            return fields != null ? fields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<Field.Builder>... fields) {
            fields(Stream.of(fields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFields(Collection<Field.BuilderImpl> fields) {
            this.fields = _fieldListCopier.copyFromBuilder(fields);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public PipelineDescription build() {
            return new PipelineDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
