/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a parameter object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterObject implements SdkPojo, Serializable, ToCopyableBuilder<ParameterObject.Builder, ParameterObject> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterObject::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<ParameterAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<ParameterAttribute>> builder(MarshallingType.LIST)
            .getter(getter(ParameterObject::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<ParameterAttribute> attributes;

    private ParameterObject(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The ID of the parameter object.
     * </p>
     * 
     * @return The ID of the parameter object.
     */
    public String id() {
        return id;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the parameter object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes of the parameter object.
     */
    public List<ParameterAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterObject)) {
            return false;
        }
        ParameterObject other = (ParameterObject) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterObject").add("Id", id()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterObject, T> g) {
        return obj -> g.apply((ParameterObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterObject> {
        /**
         * <p>
         * The ID of the parameter object.
         * </p>
         * 
         * @param id
         *        The ID of the parameter object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The attributes of the parameter object.
         * </p>
         * 
         * @param attributes
         *        The attributes of the parameter object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<ParameterAttribute> attributes);

        /**
         * <p>
         * The attributes of the parameter object.
         * </p>
         * 
         * @param attributes
         *        The attributes of the parameter object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(ParameterAttribute... attributes);

        /**
         * <p>
         * The attributes of the parameter object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(List<ParameterAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<ParameterAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<ParameterAttribute>)
         */
        Builder attributes(Consumer<ParameterAttribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<ParameterAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterObject model) {
            id(model.id);
            attributes(model.attributes);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<ParameterAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(ParameterAttribute::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attributes(Collection<ParameterAttribute> attributes) {
            this.attributes = ParameterAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(ParameterAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<ParameterAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> ParameterAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<ParameterAttribute.BuilderImpl> attributes) {
            this.attributes = ParameterAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public ParameterObject build() {
            return new ParameterObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
