/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.PipelineDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PipelineDescriptionMarshaller {
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<List> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fields").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final PipelineDescriptionMarshaller INSTANCE = new PipelineDescriptionMarshaller();

    private PipelineDescriptionMarshaller() {
    }

    public static PipelineDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineDescription pipelineDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pipelineDescription, (String)"pipelineDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pipelineDescription.pipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall((Object)pipelineDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall(pipelineDescription.fields(), FIELDS_BINDING);
            protocolMarshaller.marshall((Object)pipelineDescription.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(pipelineDescription.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

