/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClient;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;

public class QueryObjectsPublisher
implements SdkPublisher<QueryObjectsResponse> {
    private final DataPipelineAsyncClient client;
    private final QueryObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryObjectsPublisher(DataPipelineAsyncClient client, QueryObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryObjectsPublisher(DataPipelineAsyncClient client, QueryObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryObjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryObjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<String> ids() {
        Function<QueryObjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new QueryObjectsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final QueryObjectsPublisher resume(QueryObjectsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new QueryObjectsPublisher(this.client, (QueryObjectsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new QueryObjectsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super QueryObjectsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class QueryObjectsResponseFetcher
    implements AsyncPageFetcher<QueryObjectsResponse> {
        private QueryObjectsResponseFetcher() {
        }

        public boolean hasNextPage(QueryObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public CompletableFuture<QueryObjectsResponse> nextPage(QueryObjectsResponse previousPage) {
            if (previousPage == null) {
                return QueryObjectsPublisher.this.client.queryObjects(QueryObjectsPublisher.this.firstRequest);
            }
            return QueryObjectsPublisher.this.client.queryObjects((QueryObjectsRequest)((Object)QueryObjectsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

