/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;

public final class DescribeObjectsPaginator
implements SdkIterable<DescribeObjectsResponse> {
    private final DataPipelineClient client;
    private final DescribeObjectsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeObjectsPaginator(DataPipelineClient client, DescribeObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeObjectsResponseFetcher();
    }

    public Iterator<DescribeObjectsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<PipelineObject> pipelineObjects() {
        Function<DescribeObjectsResponse, Iterator> getIterator = response -> response != null ? response.pipelineObjects().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeObjectsResponseFetcher
    implements NextPageFetcher<DescribeObjectsResponse> {
        private DescribeObjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public DescribeObjectsResponse nextPage(DescribeObjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeObjectsPaginator.this.client.describeObjects(DescribeObjectsPaginator.this.firstRequest);
            }
            return DescribeObjectsPaginator.this.client.describeObjects((DescribeObjectsRequest)((Object)DescribeObjectsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

