/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;
import software.amazon.awssdk.services.datapipeline.model._pipelineListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPipelinesResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, ListPipelinesResponse> {
    private final List<PipelineIdName> pipelineIdList;
    private final String marker;
    private final Boolean hasMoreResults;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineIdList = builder.pipelineIdList;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<PipelineIdName> pipelineIdList() {
        return this.pipelineIdList;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineIdList());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse)((Object)obj);
        return Objects.equals(this.pipelineIdList(), other.pipelineIdList()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hasMoreResults(), other.hasMoreResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineIdList() != null) {
            sb.append("PipelineIdList: ").append(this.pipelineIdList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hasMoreResults() != null) {
            sb.append("HasMoreResults: ").append(this.hasMoreResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineIdList": {
                return Optional.of(clazz.cast(this.pipelineIdList()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.of(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineIdName> pipelineIdList;
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            this.pipelineIdList(model.pipelineIdList);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final Collection<PipelineIdName.Builder> getPipelineIdList() {
            return this.pipelineIdList != null ? (Collection)this.pipelineIdList.stream().map(PipelineIdName::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineIdList(Collection<PipelineIdName> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copy(pipelineIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(PipelineIdName ... pipelineIdList) {
            this.pipelineIdList(Arrays.asList(pipelineIdList));
            return this;
        }

        public final void setPipelineIdList(Collection<PipelineIdName.BuilderImpl> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copyFromBuilder(pipelineIdList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    CopyableBuilder<Builder, ListPipelinesResponse> {
        public Builder pipelineIdList(Collection<PipelineIdName> var1);

        public Builder pipelineIdList(PipelineIdName ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

