/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForTaskRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PollForTaskRequest> {
    private final String workerGroup;
    private final String hostname;
    private final InstanceIdentity instanceIdentity;

    private PollForTaskRequest(BuilderImpl builder) {
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public String workerGroup() {
        return this.workerGroup;
    }

    public String hostname() {
        return this.hostname;
    }

    public InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForTaskRequest)) {
            return false;
        }
        PollForTaskRequest other = (PollForTaskRequest)((Object)obj);
        return Objects.equals(this.workerGroup(), other.workerGroup()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.instanceIdentity(), other.instanceIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.workerGroup() != null) {
            sb.append("WorkerGroup: ").append(this.workerGroup()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.instanceIdentity() != null) {
            sb.append("InstanceIdentity: ").append(this.instanceIdentity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workerGroup": {
                return Optional.of(clazz.cast(this.workerGroup()));
            }
            case "hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "instanceIdentity": {
                return Optional.of(clazz.cast(this.instanceIdentity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String workerGroup;
        private String hostname;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForTaskRequest model) {
            this.workerGroup(model.workerGroup);
            this.hostname(model.hostname);
            this.instanceIdentity(model.instanceIdentity);
        }

        public final String getWorkerGroup() {
            return this.workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return this.instanceIdentity != null ? this.instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        public PollForTaskRequest build() {
            return new PollForTaskRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForTaskRequest> {
        public Builder workerGroup(String var1);

        public Builder hostname(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);

        default public Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return this.instanceIdentity((InstanceIdentity)((InstanceIdentity.Builder)InstanceIdentity.builder().apply(instanceIdentity)).build());
        }
    }
}

