/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.Field;
import software.amazon.awssdk.services.datapipeline.model.Tag;
import software.amazon.awssdk.services.datapipeline.model._fieldListCopier;
import software.amazon.awssdk.services.datapipeline.model._tagListCopier;
import software.amazon.awssdk.services.datapipeline.transform.PipelineDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineDescription> {
    private final String pipelineId;
    private final String name;
    private final List<Field> fields;
    private final String description;
    private final List<Tag> tags;

    private PipelineDescription(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.name = builder.name;
        this.fields = builder.fields;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String name() {
        return this.name;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public String description() {
        return this.description;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDescription)) {
            return false;
        }
        PipelineDescription other = (PipelineDescription)obj;
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.fields() != null) {
            sb.append("Fields: ").append(this.fields()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "fields": {
                return Optional.of(clazz.cast(this.fields()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private String name;
        private List<Field> fields;
        private String description;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDescription model) {
            this.pipelineId(model.pipelineId);
            this.name(model.name);
            this.fields(model.fields);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Field.Builder> getFields() {
            return this.fields != null ? (Collection)this.fields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        public final void setFields(Collection<Field.BuilderImpl> fields) {
            this.fields = _fieldListCopier.copyFromBuilder(fields);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        public PipelineDescription build() {
            return new PipelineDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineDescription> {
        public Builder pipelineId(String var1);

        public Builder name(String var1);

        public Builder fields(Collection<Field> var1);

        public Builder fields(Field ... var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

