/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeactivatePipelineRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeactivatePipelineRequest> {
    private final String pipelineId;
    private final Boolean cancelActive;

    private DeactivatePipelineRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.cancelActive = builder.cancelActive;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public Boolean cancelActive() {
        return this.cancelActive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.cancelActive() == null ? 0 : this.cancelActive().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivatePipelineRequest)) {
            return false;
        }
        DeactivatePipelineRequest other = (DeactivatePipelineRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.cancelActive() == null ^ this.cancelActive() == null) {
            return false;
        }
        return other.cancelActive() == null || other.cancelActive().equals(this.cancelActive());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.cancelActive() != null) {
            sb.append("CancelActive: ").append(this.cancelActive()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "cancelActive": {
                return Optional.of(clazz.cast(this.cancelActive()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private Boolean cancelActive;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivatePipelineRequest model) {
            this.pipelineId(model.pipelineId);
            this.cancelActive(model.cancelActive);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Boolean getCancelActive() {
            return this.cancelActive;
        }

        @Override
        public final Builder cancelActive(Boolean cancelActive) {
            this.cancelActive = cancelActive;
            return this;
        }

        public final void setCancelActive(Boolean cancelActive) {
            this.cancelActive = cancelActive;
        }

        public DeactivatePipelineRequest build() {
            return new DeactivatePipelineRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeactivatePipelineRequest> {
        public Builder pipelineId(String var1);

        public Builder cancelActive(Boolean var1);
    }
}

