/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActivatePipelineRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ActivatePipelineRequest> {
    private final String pipelineId;
    private final List<ParameterValue> parameterValues;
    private final Instant startTimestamp;

    private ActivatePipelineRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.parameterValues = builder.parameterValues;
        this.startTimestamp = builder.startTimestamp;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Instant startTimestamp() {
        return this.startTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.parameterValues() == null ? 0 : this.parameterValues().hashCode());
        hashCode = 31 * hashCode + (this.startTimestamp() == null ? 0 : this.startTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.parameterValues() == null ^ this.parameterValues() == null) {
            return false;
        }
        if (other.parameterValues() != null && !other.parameterValues().equals(this.parameterValues())) {
            return false;
        }
        if (other.startTimestamp() == null ^ this.startTimestamp() == null) {
            return false;
        }
        return other.startTimestamp() == null || other.startTimestamp().equals(this.startTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.parameterValues() != null) {
            sb.append("ParameterValues: ").append(this.parameterValues()).append(",");
        }
        if (this.startTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.startTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<ParameterValue> parameterValues;
        private Instant startTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatePipelineRequest model) {
            this.setPipelineId(model.pipelineId);
            this.setParameterValues(model.parameterValues);
            this.setStartTimestamp(model.startTimestamp);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<ParameterValue> getParameterValues() {
            return this.parameterValues;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public ActivatePipelineRequest build() {
            return new ActivatePipelineRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivatePipelineRequest> {
        public Builder pipelineId(String var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder startTimestamp(Instant var1);
    }
}

