/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model._validationMessagesCopier;
import software.amazon.awssdk.services.datapipeline.transform.ValidationErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationError
implements StructuredPojo,
ToCopyableBuilder<Builder, ValidationError> {
    private final String id;
    private final List<String> errors;

    private ValidationError(BuilderImpl builder) {
        this.id = builder.id;
        this.errors = builder.errors;
    }

    public String id() {
        return this.id;
    }

    public List<String> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.errors() == null ? 0 : this.errors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.errors() == null ^ this.errors() == null) {
            return false;
        }
        return other.errors() == null || other.errors().equals(this.errors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.errors() != null) {
            sb.append("Errors: ").append(this.errors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            this.setId(model.id);
            this.setErrors(model.errors);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getErrors() {
            return this.errors;
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
        }

        public ValidationError build() {
            return new ValidationError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationError> {
        public Builder id(String var1);

        public Builder errors(Collection<String> var1);

        public Builder errors(String ... var1);
    }
}

