/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForTaskRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PollForTaskRequest> {
    private final String workerGroup;
    private final String hostname;
    private final InstanceIdentity instanceIdentity;

    private PollForTaskRequest(BuilderImpl builder) {
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public String workerGroup() {
        return this.workerGroup;
    }

    public String hostname() {
        return this.hostname;
    }

    public InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.workerGroup() == null ? 0 : this.workerGroup().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.instanceIdentity() == null ? 0 : this.instanceIdentity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForTaskRequest)) {
            return false;
        }
        PollForTaskRequest other = (PollForTaskRequest)((Object)obj);
        if (other.workerGroup() == null ^ this.workerGroup() == null) {
            return false;
        }
        if (other.workerGroup() != null && !other.workerGroup().equals(this.workerGroup())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.instanceIdentity() == null ^ this.instanceIdentity() == null) {
            return false;
        }
        return other.instanceIdentity() == null || other.instanceIdentity().equals(this.instanceIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.workerGroup() != null) {
            sb.append("WorkerGroup: ").append(this.workerGroup()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.instanceIdentity() != null) {
            sb.append("InstanceIdentity: ").append(this.instanceIdentity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String workerGroup;
        private String hostname;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForTaskRequest model) {
            this.setWorkerGroup(model.workerGroup);
            this.setHostname(model.hostname);
            this.setInstanceIdentity(model.instanceIdentity);
        }

        public final String getWorkerGroup() {
            return this.workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final InstanceIdentity getInstanceIdentity() {
            return this.instanceIdentity;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
        }

        public PollForTaskRequest build() {
            return new PollForTaskRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForTaskRequest> {
        public Builder workerGroup(String var1);

        public Builder hostname(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);
    }
}

