/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.AddTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.AddTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineException;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.InternalServiceErrorException;
import software.amazon.awssdk.services.datapipeline.model.InvalidRequestException;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineDeletedException;
import software.amazon.awssdk.services.datapipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatResponse;
import software.amazon.awssdk.services.datapipeline.model.SetStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.TaskNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.transform.ActivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ActivatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.CreatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeactivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeactivatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeletePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribeObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribeObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribePipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribePipelinesResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.EvaluateExpressionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.EvaluateExpressionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.GetPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.GetPipelineDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ListPipelinesResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PollForTaskRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PollForTaskResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PutPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PutPipelineDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.QueryObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.QueryObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.RemoveTagsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskRunnerHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskRunnerHeartbeatResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetStatusResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetTaskStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetTaskStatusResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ValidatePipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ValidatePipelineDefinitionResponseUnmarshaller;

@SdkInternalApi
final class DefaultDataPipelineClient
implements DataPipelineClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultDataPipelineClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public ActivatePipelineResponse activatePipeline(ActivatePipelineRequest activatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ActivatePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ActivatePipelineResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)activatePipelineRequest).withMarshaller((Marshaller)new ActivatePipelineRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AddTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreatePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePipelineResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeactivatePipelineResponse deactivatePipeline(DeactivatePipelineRequest deactivatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeactivatePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeactivatePipelineResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deactivatePipelineRequest).withMarshaller((Marshaller)new DeactivatePipelineRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws PipelineNotFoundException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeletePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeletePipelineResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeObjectsResponse describeObjects(DescribeObjectsRequest describeObjectsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeObjectsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeObjectsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeObjectsRequest).withMarshaller((Marshaller)new DescribeObjectsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribePipelinesResponse describePipelines(DescribePipelinesRequest describePipelinesRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribePipelinesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribePipelinesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describePipelinesRequest).withMarshaller((Marshaller)new DescribePipelinesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EvaluateExpressionResponse evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EvaluateExpressionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EvaluateExpressionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)evaluateExpressionRequest).withMarshaller((Marshaller)new EvaluateExpressionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetPipelineDefinitionResponse getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetPipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetPipelineDefinitionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getPipelineDefinitionRequest).withMarshaller((Marshaller)new GetPipelineDefinitionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListPipelinesResponse listPipelines() throws InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        return this.listPipelines((ListPipelinesRequest)((Object)ListPipelinesRequest.builder().build()));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListPipelinesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPipelinesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PollForTaskResponse pollForTask(PollForTaskRequest pollForTaskRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PollForTaskResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PollForTaskResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)pollForTaskRequest).withMarshaller((Marshaller)new PollForTaskRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PutPipelineDefinitionResponse putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutPipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutPipelineDefinitionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putPipelineDefinitionRequest).withMarshaller((Marshaller)new PutPipelineDefinitionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public QueryObjectsResponse queryObjects(QueryObjectsRequest queryObjectsRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new QueryObjectsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (QueryObjectsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)queryObjectsRequest).withMarshaller((Marshaller)new QueryObjectsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RemoveTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ReportTaskProgressResponse reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ReportTaskProgressResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReportTaskProgressResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)reportTaskProgressRequest).withMarshaller((Marshaller)new ReportTaskProgressRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ReportTaskRunnerHeartbeatResponse reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) throws InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ReportTaskRunnerHeartbeatResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReportTaskRunnerHeartbeatResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)reportTaskRunnerHeartbeatRequest).withMarshaller((Marshaller)new ReportTaskRunnerHeartbeatRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SetStatusResponse setStatus(SetStatusRequest setStatusRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SetStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetStatusResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)setStatusRequest).withMarshaller((Marshaller)new SetStatusRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SetTaskStatusResponse setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SetTaskStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetTaskStatusResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)setTaskStatusRequest).withMarshaller((Marshaller)new SetTaskStatusRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ValidatePipelineDefinitionResponse validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkBaseException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ValidatePipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ValidatePipelineDefinitionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)validatePipelineDefinitionRequest).withMarshaller((Marshaller)new ValidatePipelineDefinitionRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DataPipelineException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TaskNotFoundException").withModeledClass(TaskNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineDeletedException").withModeledClass(PipelineDeletedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNotFoundException").withModeledClass(PipelineNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceError").withModeledClass(InternalServiceErrorException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

