/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.transform.ParameterAttributeUnmarshaller;

public class ParameterObjectUnmarshaller
implements Unmarshaller<ParameterObject, JsonUnmarshallerContext> {
    private static final ParameterObjectUnmarshaller INSTANCE = new ParameterObjectUnmarshaller();

    public ParameterObject unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParameterObject.Builder parameterObjectBuilder = ParameterObject.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    parameterObjectBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("attributes", targetDepth)) {
                    context.nextToken();
                    parameterObjectBuilder.attributes(new ListUnmarshaller((Unmarshaller)ParameterAttributeUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ParameterObject)parameterObjectBuilder.build();
    }

    public static ParameterObjectUnmarshaller getInstance() {
        return INSTANCE;
    }
}

