/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectMapCopier;
import software.amazon.awssdk.services.datapipeline.transform.TaskObjectMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskObject
implements StructuredPojo,
ToCopyableBuilder<Builder, TaskObject> {
    private final String taskId;
    private final String pipelineId;
    private final String attemptId;
    private final Map<String, PipelineObject> objects;

    private TaskObject(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.pipelineId = builder.pipelineId;
        this.attemptId = builder.attemptId;
        this.objects = builder.objects;
    }

    public String taskId() {
        return this.taskId;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public Map<String, PipelineObject> objects() {
        return this.objects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objects());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskObject)) {
            return false;
        }
        TaskObject other = (TaskObject)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.attemptId(), other.attemptId()) && Objects.equals(this.objects(), other.objects());
    }

    public String toString() {
        return ToString.builder((String)"TaskObject").add("TaskId", (Object)this.taskId()).add("PipelineId", (Object)this.pipelineId()).add("AttemptId", (Object)this.attemptId()).add("Objects", this.objects()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "attemptId": {
                return Optional.ofNullable(clazz.cast(this.attemptId()));
            }
            case "objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String pipelineId;
        private String attemptId;
        private Map<String, PipelineObject> objects = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskObject model) {
            this.taskId(model.taskId);
            this.pipelineId(model.pipelineId);
            this.attemptId(model.attemptId);
            this.objects(model.objects);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getAttemptId() {
            return this.attemptId;
        }

        @Override
        public final Builder attemptId(String attemptId) {
            this.attemptId = attemptId;
            return this;
        }

        public final void setAttemptId(String attemptId) {
            this.attemptId = attemptId;
        }

        public final Map<String, PipelineObject.Builder> getObjects() {
            return this.objects != null ? CollectionUtils.mapValues(this.objects, PipelineObject::toBuilder) : null;
        }

        @Override
        public final Builder objects(Map<String, PipelineObject> objects) {
            this.objects = PipelineObjectMapCopier.copy(objects);
            return this;
        }

        public final void setObjects(Map<String, PipelineObject.BuilderImpl> objects) {
            this.objects = PipelineObjectMapCopier.copyFromBuilder(objects);
        }

        public TaskObject build() {
            return new TaskObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TaskObject> {
        public Builder taskId(String var1);

        public Builder pipelineId(String var1);

        public Builder attemptId(String var1);

        public Builder objects(Map<String, PipelineObject> var1);
    }
}

