/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.Operator;
import software.amazon.awssdk.services.datapipeline.transform.SelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Selector
implements StructuredPojo,
ToCopyableBuilder<Builder, Selector> {
    private final String fieldName;
    private final Operator operator;

    private Selector(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.operator = builder.operator;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Operator operator() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Selector)) {
            return false;
        }
        Selector other = (Selector)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.operator(), other.operator());
    }

    public String toString() {
        return ToString.builder((String)"Selector").add("FieldName", (Object)this.fieldName()).add("Operator", (Object)this.operator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private Operator operator;

        private BuilderImpl() {
        }

        private BuilderImpl(Selector model) {
            this.fieldName(model.fieldName);
            this.operator(model.operator);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final Operator.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public final void setOperator(Operator.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        public Selector build() {
            return new Selector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Selector> {
        public Builder fieldName(String var1);

        public Builder operator(Operator var1);

        default public Builder operator(Consumer<Operator.Builder> operator) {
            return this.operator((Operator)((Operator.Builder)Operator.builder().applyMutation(operator)).build());
        }
    }
}

