/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PollForTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> WORKERGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workerGroup").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostname").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCEIDENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceIdentity").isBinary(false).build();
    private static final PollForTaskRequestModelMarshaller INSTANCE = new PollForTaskRequestModelMarshaller();

    private PollForTaskRequestModelMarshaller() {
    }

    public static PollForTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PollForTaskRequest pollForTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)pollForTaskRequest), (String)"pollForTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pollForTaskRequest.workerGroup(), WORKERGROUP_BINDING);
            protocolMarshaller.marshall((Object)pollForTaskRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)pollForTaskRequest.instanceIdentity(), INSTANCEIDENTITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

