/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;

public class ListPipelinesIterable
implements SdkIterable<ListPipelinesResponse> {
    private final DataPipelineClient client;
    private final ListPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelinesIterable(DataPipelineClient client, ListPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public Iterator<ListPipelinesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<PipelineIdName> pipelineIdList() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineIdList() != null) {
                return response.pipelineIdList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListPipelinesIterable resume(ListPipelinesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPipelinesIterable(this.client, (ListPipelinesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPipelinesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPipelinesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPipelinesResponseFetcher
    implements SyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public ListPipelinesResponse nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesIterable.this.client.listPipelines(ListPipelinesIterable.this.firstRequest);
            }
            return ListPipelinesIterable.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

