/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model._validationMessagesCopier;
import software.amazon.awssdk.services.datapipeline.transform.ValidationWarningMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationWarning
implements StructuredPojo,
ToCopyableBuilder<Builder, ValidationWarning> {
    private final String id;
    private final List<String> warnings;

    private ValidationWarning(BuilderImpl builder) {
        this.id = builder.id;
        this.warnings = builder.warnings;
    }

    public String id() {
        return this.id;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.warnings() == null ? 0 : this.warnings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationWarning)) {
            return false;
        }
        ValidationWarning other = (ValidationWarning)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.warnings() == null ^ this.warnings() == null) {
            return false;
        }
        return other.warnings() == null || other.warnings().equals(this.warnings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.warnings() != null) {
            sb.append("Warnings: ").append(this.warnings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationWarningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> warnings = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationWarning model) {
            this.setId(model.id);
            this.setWarnings(model.warnings);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            if (this.warnings == null) {
                this.warnings = new SdkInternalList(warnings.length);
            }
            for (String e : warnings) {
                this.warnings.add(e);
            }
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
        }

        @SafeVarargs
        public final void setWarnings(String ... warnings) {
            if (this.warnings == null) {
                this.warnings = new SdkInternalList(warnings.length);
            }
            for (String e : warnings) {
                this.warnings.add(e);
            }
        }

        public ValidationWarning build() {
            return new ValidationWarning(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationWarning> {
        public Builder id(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);
    }
}

