/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.model.ParameterObjectListCopier;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidatePipelineDefinitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ValidatePipelineDefinitionRequest> {
    private final String pipelineId;
    private final List<PipelineObject> pipelineObjects;
    private final List<ParameterObject> parameterObjects;
    private final List<ParameterValue> parameterValues;

    private ValidatePipelineDefinitionRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public List<ParameterObject> parameterObjects() {
        return this.parameterObjects;
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.pipelineObjects() == null ? 0 : this.pipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.parameterObjects() == null ? 0 : this.parameterObjects().hashCode());
        hashCode = 31 * hashCode + (this.parameterValues() == null ? 0 : this.parameterValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionRequest)) {
            return false;
        }
        ValidatePipelineDefinitionRequest other = (ValidatePipelineDefinitionRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.pipelineObjects() == null ^ this.pipelineObjects() == null) {
            return false;
        }
        if (other.pipelineObjects() != null && !other.pipelineObjects().equals(this.pipelineObjects())) {
            return false;
        }
        if (other.parameterObjects() == null ^ this.parameterObjects() == null) {
            return false;
        }
        if (other.parameterObjects() != null && !other.parameterObjects().equals(this.parameterObjects())) {
            return false;
        }
        if (other.parameterValues() == null ^ this.parameterValues() == null) {
            return false;
        }
        return other.parameterValues() == null || other.parameterValues().equals(this.parameterValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.pipelineObjects() != null) {
            sb.append("PipelineObjects: ").append(this.pipelineObjects()).append(",");
        }
        if (this.parameterObjects() != null) {
            sb.append("ParameterObjects: ").append(this.parameterObjects()).append(",");
        }
        if (this.parameterValues() != null) {
            sb.append("ParameterValues: ").append(this.parameterValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<PipelineObject> pipelineObjects = new SdkInternalList();
        private List<ParameterObject> parameterObjects = new SdkInternalList();
        private List<ParameterValue> parameterValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineDefinitionRequest model) {
            this.setPipelineId(model.pipelineId);
            this.setPipelineObjects(model.pipelineObjects);
            this.setParameterObjects(model.parameterObjects);
            this.setParameterValues(model.parameterValues);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<PipelineObject> getPipelineObjects() {
            return this.pipelineObjects;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            if (this.pipelineObjects == null) {
                this.pipelineObjects = new SdkInternalList(pipelineObjects.length);
            }
            for (PipelineObject e : pipelineObjects) {
                this.pipelineObjects.add(e);
            }
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
        }

        @SafeVarargs
        public final void setPipelineObjects(PipelineObject ... pipelineObjects) {
            if (this.pipelineObjects == null) {
                this.pipelineObjects = new SdkInternalList(pipelineObjects.length);
            }
            for (PipelineObject e : pipelineObjects) {
                this.pipelineObjects.add(e);
            }
        }

        public final Collection<ParameterObject> getParameterObjects() {
            return this.parameterObjects;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject ... parameterObjects) {
            if (this.parameterObjects == null) {
                this.parameterObjects = new SdkInternalList(parameterObjects.length);
            }
            for (ParameterObject e : parameterObjects) {
                this.parameterObjects.add(e);
            }
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
        }

        @SafeVarargs
        public final void setParameterObjects(ParameterObject ... parameterObjects) {
            if (this.parameterObjects == null) {
                this.parameterObjects = new SdkInternalList(parameterObjects.length);
            }
            for (ParameterObject e : parameterObjects) {
                this.parameterObjects.add(e);
            }
        }

        public final Collection<ParameterValue> getParameterValues() {
            return this.parameterValues;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            if (this.parameterValues == null) {
                this.parameterValues = new SdkInternalList(parameterValues.length);
            }
            for (ParameterValue e : parameterValues) {
                this.parameterValues.add(e);
            }
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
        }

        @SafeVarargs
        public final void setParameterValues(ParameterValue ... parameterValues) {
            if (this.parameterValues == null) {
                this.parameterValues = new SdkInternalList(parameterValues.length);
            }
            for (ParameterValue e : parameterValues) {
                this.parameterValues.add(e);
            }
        }

        public ValidatePipelineDefinitionRequest build() {
            return new ValidatePipelineDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidatePipelineDefinitionRequest> {
        public Builder pipelineId(String var1);

        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder parameterObjects(Collection<ParameterObject> var1);

        public Builder parameterObjects(ParameterObject ... var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);
    }
}

