/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;
import software.amazon.awssdk.services.datapipeline.model._pipelineListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPipelinesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPipelinesResponse> {
    private final List<PipelineIdName> pipelineIdList;
    private final String marker;
    private final Boolean hasMoreResults;

    private ListPipelinesResponse(BuilderImpl builder) {
        this.pipelineIdList = builder.pipelineIdList;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<PipelineIdName> pipelineIdList() {
        return this.pipelineIdList;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineIdList() == null ? 0 : this.pipelineIdList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreResults() == null ? 0 : this.hasMoreResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse)((Object)obj);
        if (other.pipelineIdList() == null ^ this.pipelineIdList() == null) {
            return false;
        }
        if (other.pipelineIdList() != null && !other.pipelineIdList().equals(this.pipelineIdList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.hasMoreResults() == null ^ this.hasMoreResults() == null) {
            return false;
        }
        return other.hasMoreResults() == null || other.hasMoreResults().equals(this.hasMoreResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineIdList() != null) {
            sb.append("PipelineIdList: ").append(this.pipelineIdList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hasMoreResults() != null) {
            sb.append("HasMoreResults: ").append(this.hasMoreResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PipelineIdName> pipelineIdList = new SdkInternalList();
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            this.setPipelineIdList(model.pipelineIdList);
            this.setMarker(model.marker);
            this.setHasMoreResults(model.hasMoreResults);
        }

        public final Collection<PipelineIdName> getPipelineIdList() {
            return this.pipelineIdList;
        }

        @Override
        public final Builder pipelineIdList(Collection<PipelineIdName> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copy(pipelineIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(PipelineIdName ... pipelineIdList) {
            if (this.pipelineIdList == null) {
                this.pipelineIdList = new SdkInternalList(pipelineIdList.length);
            }
            for (PipelineIdName e : pipelineIdList) {
                this.pipelineIdList.add(e);
            }
            return this;
        }

        public final void setPipelineIdList(Collection<PipelineIdName> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copy(pipelineIdList);
        }

        @SafeVarargs
        public final void setPipelineIdList(PipelineIdName ... pipelineIdList) {
            if (this.pipelineIdList == null) {
                this.pipelineIdList = new SdkInternalList(pipelineIdList.length);
            }
            for (PipelineIdName e : pipelineIdList) {
                this.pipelineIdList.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPipelinesResponse> {
        public Builder pipelineIdList(Collection<PipelineIdName> var1);

        public Builder pipelineIdList(PipelineIdName ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

