/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.AcceptanceStateFilterValue;
import software.amazon.awssdk.services.dataexchange.model.AcceptanceStateFilterValuesCopier;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReceivedDataGrantsRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, ListReceivedDataGrantsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListReceivedDataGrantsRequest.getter(ListReceivedDataGrantsRequest::maxResults)).setter(ListReceivedDataGrantsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReceivedDataGrantsRequest.getter(ListReceivedDataGrantsRequest::nextToken)).setter(ListReceivedDataGrantsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> ACCEPTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceptanceState").getter(ListReceivedDataGrantsRequest.getter(ListReceivedDataGrantsRequest::acceptanceStateAsStrings)).setter(ListReceivedDataGrantsRequest.setter(Builder::acceptanceStateWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("acceptanceState").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ACCEPTANCE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReceivedDataGrantsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> acceptanceState;

    private ListReceivedDataGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.acceptanceState = builder.acceptanceState;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<AcceptanceStateFilterValue> acceptanceState() {
        return AcceptanceStateFilterValuesCopier.copyStringToEnum(this.acceptanceState);
    }

    public final boolean hasAcceptanceState() {
        return this.acceptanceState != null && !(this.acceptanceState instanceof SdkAutoConstructList);
    }

    public final List<String> acceptanceStateAsStrings() {
        return this.acceptanceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceptanceState() ? this.acceptanceStateAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceivedDataGrantsRequest)) {
            return false;
        }
        ListReceivedDataGrantsRequest other = (ListReceivedDataGrantsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasAcceptanceState() == other.hasAcceptanceState() && Objects.equals(this.acceptanceStateAsStrings(), other.acceptanceStateAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListReceivedDataGrantsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("AcceptanceState", this.hasAcceptanceState() ? this.acceptanceStateAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AcceptanceState": {
                return Optional.ofNullable(clazz.cast(this.acceptanceStateAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("acceptanceState", ACCEPTANCE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReceivedDataGrantsRequest, T> g) {
        return obj -> g.apply((ListReceivedDataGrantsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> acceptanceState = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceivedDataGrantsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.acceptanceStateWithStrings(model.acceptanceState);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getAcceptanceState() {
            if (this.acceptanceState instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceptanceState;
        }

        public final void setAcceptanceState(Collection<String> acceptanceState) {
            this.acceptanceState = AcceptanceStateFilterValuesCopier.copy(acceptanceState);
        }

        @Override
        public final Builder acceptanceStateWithStrings(Collection<String> acceptanceState) {
            this.acceptanceState = AcceptanceStateFilterValuesCopier.copy(acceptanceState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptanceStateWithStrings(String ... acceptanceState) {
            this.acceptanceStateWithStrings(Arrays.asList(acceptanceState));
            return this;
        }

        @Override
        public final Builder acceptanceState(Collection<AcceptanceStateFilterValue> acceptanceState) {
            this.acceptanceState = AcceptanceStateFilterValuesCopier.copyEnumToString(acceptanceState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptanceState(AcceptanceStateFilterValue ... acceptanceState) {
            this.acceptanceState(Arrays.asList(acceptanceState));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReceivedDataGrantsRequest build() {
            return new ListReceivedDataGrantsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReceivedDataGrantsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder acceptanceStateWithStrings(Collection<String> var1);

        public Builder acceptanceStateWithStrings(String ... var1);

        public Builder acceptanceState(Collection<AcceptanceStateFilterValue> var1);

        public Builder acceptanceState(AcceptanceStateFilterValue ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

