/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Type {
    IMPORT_ASSETS_FROM_S3("IMPORT_ASSETS_FROM_S3"),
    IMPORT_ASSET_FROM_SIGNED_URL("IMPORT_ASSET_FROM_SIGNED_URL"),
    EXPORT_ASSETS_TO_S3("EXPORT_ASSETS_TO_S3"),
    EXPORT_ASSET_TO_SIGNED_URL("EXPORT_ASSET_TO_SIGNED_URL"),
    EXPORT_REVISIONS_TO_S3("EXPORT_REVISIONS_TO_S3"),
    IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES("IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES"),
    IMPORT_ASSET_FROM_API_GATEWAY_API("IMPORT_ASSET_FROM_API_GATEWAY_API"),
    CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET("CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET"),
    IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY("IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Type> VALUE_MAP;
    private final String value;

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Type> knownValues() {
        EnumSet<Type> knownValues = EnumSet.allOf(Type.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Type.class, Type::toString);
    }
}

