/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyPermission;
import software.amazon.awssdk.services.dataexchange.model.LFTag;
import software.amazon.awssdk.services.dataexchange.model.ListOfDatabaseLFTagPolicyPermissionsCopier;
import software.amazon.awssdk.services.dataexchange.model.ListOfLFTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseLFTagPolicyAndPermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseLFTagPolicyAndPermissions> {
    private static final SdkField<List<LFTag>> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Expression").getter(DatabaseLFTagPolicyAndPermissions.getter(DatabaseLFTagPolicyAndPermissions::expression)).setter(DatabaseLFTagPolicyAndPermissions.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LFTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(DatabaseLFTagPolicyAndPermissions.getter(DatabaseLFTagPolicyAndPermissions::permissionsAsStrings)).setter(DatabaseLFTagPolicyAndPermissions.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatabaseLFTagPolicyAndPermissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LFTag> expression;
    private final List<String> permissions;

    private DatabaseLFTagPolicyAndPermissions(BuilderImpl builder) {
        this.expression = builder.expression;
        this.permissions = builder.permissions;
    }

    public final boolean hasExpression() {
        return this.expression != null && !(this.expression instanceof SdkAutoConstructList);
    }

    public final List<LFTag> expression() {
        return this.expression;
    }

    public final List<DatabaseLFTagPolicyPermission> permissions() {
        return ListOfDatabaseLFTagPolicyPermissionsCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpression() ? this.expression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseLFTagPolicyAndPermissions)) {
            return false;
        }
        DatabaseLFTagPolicyAndPermissions other = (DatabaseLFTagPolicyAndPermissions)obj;
        return this.hasExpression() == other.hasExpression() && Objects.equals(this.expression(), other.expression()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseLFTagPolicyAndPermissions").add("Expression", this.hasExpression() ? this.expression() : null).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseLFTagPolicyAndPermissions, T> g) {
        return obj -> g.apply((DatabaseLFTagPolicyAndPermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LFTag> expression = DefaultSdkAutoConstructList.getInstance();
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseLFTagPolicyAndPermissions model) {
            this.expression(model.expression);
            this.permissionsWithStrings(model.permissions);
        }

        public final List<LFTag.Builder> getExpression() {
            List<LFTag.Builder> result = ListOfLFTagsCopier.copyToBuilder(this.expression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpression(Collection<LFTag.BuilderImpl> expression) {
            this.expression = ListOfLFTagsCopier.copyFromBuilder(expression);
        }

        @Override
        public final Builder expression(Collection<LFTag> expression) {
            this.expression = ListOfLFTagsCopier.copy(expression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(LFTag ... expression) {
            this.expression(Arrays.asList(expression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(Consumer<LFTag.Builder> ... expression) {
            this.expression(Stream.of(expression).map(c -> (LFTag)((LFTag.Builder)LFTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = ListOfDatabaseLFTagPolicyPermissionsCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = ListOfDatabaseLFTagPolicyPermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<DatabaseLFTagPolicyPermission> permissions) {
            this.permissions = ListOfDatabaseLFTagPolicyPermissionsCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(DatabaseLFTagPolicyPermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public DatabaseLFTagPolicyAndPermissions build() {
            return new DatabaseLFTagPolicyAndPermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseLFTagPolicyAndPermissions> {
        public Builder expression(Collection<LFTag> var1);

        public Builder expression(LFTag ... var1);

        public Builder expression(Consumer<LFTag.Builder> ... var1);

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<DatabaseLFTagPolicyPermission> var1);

        public Builder permissions(DatabaseLFTagPolicyPermission ... var1);
    }
}

