/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataAccessDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataAccessDetails> {
    private static final SdkField<List<String>> KEY_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPrefixes").getter(S3DataAccessDetails.getter(S3DataAccessDetails::keyPrefixes)).setter(S3DataAccessDetails.setter(Builder::keyPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(S3DataAccessDetails.getter(S3DataAccessDetails::keys)).setter(S3DataAccessDetails.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PREFIXES_FIELD, KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyPrefixes", KEY_PREFIXES_FIELD);
            this.put("Keys", KEYS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> keyPrefixes;
    private final List<String> keys;

    private S3DataAccessDetails(BuilderImpl builder) {
        this.keyPrefixes = builder.keyPrefixes;
        this.keys = builder.keys;
    }

    public final boolean hasKeyPrefixes() {
        return this.keyPrefixes != null && !(this.keyPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> keyPrefixes() {
        return this.keyPrefixes;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<String> keys() {
        return this.keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPrefixes() ? this.keyPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessDetails)) {
            return false;
        }
        S3DataAccessDetails other = (S3DataAccessDetails)obj;
        return this.hasKeyPrefixes() == other.hasKeyPrefixes() && Objects.equals(this.keyPrefixes(), other.keyPrefixes()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataAccessDetails").add("KeyPrefixes", this.hasKeyPrefixes() ? this.keyPrefixes() : null).add("Keys", this.hasKeys() ? this.keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPrefixes": {
                return Optional.ofNullable(clazz.cast(this.keyPrefixes()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3DataAccessDetails, T> g) {
        return obj -> g.apply((S3DataAccessDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> keyPrefixes = DefaultSdkAutoConstructList.getInstance();
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataAccessDetails model) {
            this.keyPrefixes(model.keyPrefixes);
            this.keys(model.keys);
        }

        public final Collection<String> getKeyPrefixes() {
            if (this.keyPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyPrefixes;
        }

        public final void setKeyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
        }

        @Override
        public final Builder keyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPrefixes(String ... keyPrefixes) {
            this.keyPrefixes(Arrays.asList(keyPrefixes));
            return this;
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public S3DataAccessDetails build() {
            return new S3DataAccessDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataAccessDetails> {
        public Builder keyPrefixes(Collection<String> var1);

        public Builder keyPrefixes(String ... var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);
    }
}

