/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClientBuilder;
import software.amazon.awssdk.services.dataexchange.DataExchangeServiceClientConfiguration;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeBaseClientBuilder;
import software.amazon.awssdk.services.dataexchange.endpoints.DataExchangeEndpointProvider;

@SdkInternalApi
final class DefaultDataExchangeAsyncClientBuilder
extends DefaultDataExchangeBaseClientBuilder<DataExchangeAsyncClientBuilder, DataExchangeAsyncClient>
implements DataExchangeAsyncClientBuilder {
    DefaultDataExchangeAsyncClientBuilder() {
    }

    @Override
    public DefaultDataExchangeAsyncClientBuilder endpointProvider(DataExchangeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataExchangeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDataExchangeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DataExchangeServiceClientConfiguration serviceClientConfiguration = DataExchangeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDataExchangeAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

