/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Type {
    IMPORT_ASSETS_FROM_S3("IMPORT_ASSETS_FROM_S3"),

    IMPORT_ASSET_FROM_SIGNED_URL("IMPORT_ASSET_FROM_SIGNED_URL"),

    EXPORT_ASSETS_TO_S3("EXPORT_ASSETS_TO_S3"),

    EXPORT_ASSET_TO_SIGNED_URL("EXPORT_ASSET_TO_SIGNED_URL"),

    EXPORT_REVISIONS_TO_S3("EXPORT_REVISIONS_TO_S3"),

    IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES("IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES"),

    IMPORT_ASSET_FROM_API_GATEWAY_API("IMPORT_ASSET_FROM_API_GATEWAY_API"),

    CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET("CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET"),

    IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY("IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Type> VALUE_MAP = EnumUtils.uniqueIndex(Type.class, Type::toString);

    private final String value;

    private Type(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Type corresponding to the value
     */
    public static Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Type}s
     */
    public static Set<Type> knownValues() {
        Set<Type> knownValues = EnumSet.allOf(Type.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
