/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the assets imported from an AWS Lake Formation tag policy request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportAssetsFromLakeFormationTagPolicyRequestDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ImportAssetsFromLakeFormationTagPolicyRequestDetails.Builder, ImportAssetsFromLakeFormationTagPolicyRequestDetails> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DatabaseLFTagPolicyAndPermissions> DATABASE_FIELD = SdkField
            .<DatabaseLFTagPolicyAndPermissions> builder(MarshallingType.SDK_POJO).memberName("Database")
            .getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::database)).setter(setter(Builder::database))
            .constructor(DatabaseLFTagPolicyAndPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<TableLFTagPolicyAndPermissions> TABLE_FIELD = SdkField
            .<TableLFTagPolicyAndPermissions> builder(MarshallingType.SDK_POJO).memberName("Table")
            .getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::table)).setter(setter(Builder::table))
            .constructor(TableLFTagPolicyAndPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_FIELD, TABLE_FIELD, ROLE_ARN_FIELD, DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final DatabaseLFTagPolicyAndPermissions database;

    private final TableLFTagPolicyAndPermissions table;

    private final String roleArn;

    private final String dataSetId;

    private final String revisionId;

    private ImportAssetsFromLakeFormationTagPolicyRequestDetails(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.database = builder.database;
        this.table = builder.table;
        this.roleArn = builder.roleArn;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The identifier for the AWS Glue Data Catalog.
     * </p>
     * 
     * @return The identifier for the AWS Glue Data Catalog.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A structure for the database object.
     * </p>
     * 
     * @return A structure for the database object.
     */
    public final DatabaseLFTagPolicyAndPermissions database() {
        return database;
    }

    /**
     * <p>
     * A structure for the table object.
     * </p>
     * 
     * @return A structure for the table object.
     */
    public final TableLFTagPolicyAndPermissions table() {
        return table;
    }

    /**
     * <p>
     * The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions of
     * subscribers to AWS Lake Formation data permissions.
     * </p>
     * 
     * @return The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions of
     *         subscribers to AWS Lake Formation data permissions.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this import job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this import job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this import job.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this import job.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetsFromLakeFormationTagPolicyRequestDetails)) {
            return false;
        }
        ImportAssetsFromLakeFormationTagPolicyRequestDetails other = (ImportAssetsFromLakeFormationTagPolicyRequestDetails) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportAssetsFromLakeFormationTagPolicyRequestDetails").add("CatalogId", catalogId())
                .add("Database", database()).add("Table", table()).add("RoleArn", roleArn()).add("DataSetId", dataSetId())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetsFromLakeFormationTagPolicyRequestDetails, T> g) {
        return obj -> g.apply((ImportAssetsFromLakeFormationTagPolicyRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportAssetsFromLakeFormationTagPolicyRequestDetails> {
        /**
         * <p>
         * The identifier for the AWS Glue Data Catalog.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A structure for the database object.
         * </p>
         * 
         * @param database
         *        A structure for the database object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(DatabaseLFTagPolicyAndPermissions database);

        /**
         * <p>
         * A structure for the database object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatabaseLFTagPolicyAndPermissions.Builder} avoiding the need to create one manually via
         * {@link DatabaseLFTagPolicyAndPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseLFTagPolicyAndPermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #database(DatabaseLFTagPolicyAndPermissions)}.
         * 
         * @param database
         *        a consumer that will call methods on {@link DatabaseLFTagPolicyAndPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #database(DatabaseLFTagPolicyAndPermissions)
         */
        default Builder database(Consumer<DatabaseLFTagPolicyAndPermissions.Builder> database) {
            return database(DatabaseLFTagPolicyAndPermissions.builder().applyMutation(database).build());
        }

        /**
         * <p>
         * A structure for the table object.
         * </p>
         * 
         * @param table
         *        A structure for the table object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableLFTagPolicyAndPermissions table);

        /**
         * <p>
         * A structure for the table object.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableLFTagPolicyAndPermissions.Builder}
         * avoiding the need to create one manually via {@link TableLFTagPolicyAndPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableLFTagPolicyAndPermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #table(TableLFTagPolicyAndPermissions)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link TableLFTagPolicyAndPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(TableLFTagPolicyAndPermissions)
         */
        default Builder table(Consumer<TableLFTagPolicyAndPermissions.Builder> table) {
            return table(TableLFTagPolicyAndPermissions.builder().applyMutation(table).build());
        }

        /**
         * <p>
         * The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions of
         * subscribers to AWS Lake Formation data permissions.
         * </p>
         * 
         * @param roleArn
         *        The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions
         *        of subscribers to AWS Lake Formation data permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The unique identifier for the data set associated with this import job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this import job.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private DatabaseLFTagPolicyAndPermissions database;

        private TableLFTagPolicyAndPermissions table;

        private String roleArn;

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetsFromLakeFormationTagPolicyRequestDetails model) {
            catalogId(model.catalogId);
            database(model.database);
            table(model.table);
            roleArn(model.roleArn);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DatabaseLFTagPolicyAndPermissions.Builder getDatabase() {
            return database != null ? database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseLFTagPolicyAndPermissions.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseLFTagPolicyAndPermissions database) {
            this.database = database;
            return this;
        }

        public final TableLFTagPolicyAndPermissions.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(TableLFTagPolicyAndPermissions.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableLFTagPolicyAndPermissions table) {
            this.table = table;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public ImportAssetsFromLakeFormationTagPolicyRequestDetails build() {
            return new ImportAssetsFromLakeFormationTagPolicyRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
